/* toplevel.cpp

  Copyright (C) 1998   Andreas W�st (AndreasWuest@gmx.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  */

#include <tqgroupbox.h>
#include <tqlayout.h>

#include <tdeglobal.h>
#include <tdelocale.h>
#include <ksimpleconfig.h>
#include <kstandarddirs.h>
#include <tdeapplication.h>

#include "gamewidget.h"
#include "toplevel.h"
#include "settings.h"
#include "configbox.h"
#include <tdeaction.h>
#include <kstdaction.h>
#include <kstdgameaction.h>
#include <kdebug.h>

extern Options settings;

void AtomTopLevel::createMenu()
{
    TDEAction *act = KStdGameAction::highscores(TQT_TQOBJECT(main), TQT_SLOT(showHighscores()), actionCollection());
    act->setText(i18n("Show &Highscores"));
    KStdGameAction::quit(TQT_TQOBJECT(this), TQT_SLOT(close()), actionCollection());
    KStdGameAction::restart(TQT_TQOBJECT(main), TQT_SLOT(restartLevel()), actionCollection());

    KStdAction::preferences(TQT_TQOBJECT(this), TQT_SLOT(configopts()), actionCollection());

    undoAction = KStdGameAction::undo (TQT_TQOBJECT(main), TQT_SLOT(doUndo()), actionCollection());
    redoAction = KStdGameAction::redo (TQT_TQOBJECT(main), TQT_SLOT(doRedo()), actionCollection());
    undoAction->setEnabled(false);
    redoAction->setEnabled(false);
    connect (main, TQT_SIGNAL (enableRedo(bool)), TQT_SLOT(enableRedo(bool)));
    connect (main, TQT_SIGNAL (enableUndo(bool)), TQT_SLOT(enableUndo(bool)));

    new TDEAction(i18n("Atom Up"), Key_Up, TQT_TQOBJECT(main), TQT_SLOT(moveUp()), actionCollection(), "atom_up");
    new TDEAction(i18n("Atom Down"), Key_Down, TQT_TQOBJECT(main), TQT_SLOT(moveDown()), actionCollection(), "atom_down");
    new TDEAction(i18n("Atom Left"), Key_Left, TQT_TQOBJECT(main), TQT_SLOT(moveLeft()), actionCollection(), "atom_left");
    new TDEAction(i18n("Atom Right"), Key_Right, TQT_TQOBJECT(main), TQT_SLOT(moveRight()), actionCollection(), "atom_right");

    new TDEAction(i18n("Next Atom"), Key_Tab, TQT_TQOBJECT(main), TQT_SLOT(nextAtom()), actionCollection(), "next_atom");
    new TDEAction(i18n("Previous Atom"), SHIFT+Key_Tab, TQT_TQOBJECT(main), TQT_SLOT(previousAtom()), actionCollection(), "prev_atom");
}

void AtomTopLevel::configopts()
{
    (new ConfigBox(this, "Options"))->show();
}

void AtomTopLevel::initConfig()
{
    config = TDEGlobal::config();
}

void AtomTopLevel::saveConfig()
{
    config = TDEGlobal::config();

    if (settings.changed) {
	  config->setGroup("Options");
	  config->writeEntry("Animation Speed", settings.anim_speed);
	  config->setGroup("Colors");
    }
    config->sync();
}


AtomTopLevel::AtomTopLevel()
{
    main = new GameWidget(this, "gamewidget");
    createMenu();
    initConfig();
    setCentralWidget(main);

    setupGUI( TDEMainWindow::Save | Keys | Create );
}

AtomTopLevel::~AtomTopLevel()
{
}

bool AtomTopLevel::queryExit()
{
    saveConfig();
    return true;
}

void AtomTopLevel::enableRedo(bool enable)
{
    redoAction->setEnabled(enable);
}

void AtomTopLevel::enableUndo(bool enable)
{
    undoAction->setEnabled(enable);
}

#include "toplevel.moc"
