
#include "xparthost_kpart.h"
#include "shell_xparthost.h"

#include <dcopclient.h>
#include <dcopobject.h>
#include <tdeapplication.h>
#include <kstdaction.h>
#include <tdeaction.h>
#include <tdemainwindow.h>
#include <kprocess.h>
#include <tdeparts/mainwindow.h>
#include <kdebug.h>

ShellWindow::ShellWindow()
    : KParts::MainWindow()
{
    m_host = new XPartHost_KPart( this, 0, this, "parthost" );

    setCentralWidget( m_host->widget() );

    connect(m_host, TQT_SIGNAL( actionsInitialized() ), this, TQT_SLOT( mergeGUI() ) );

    // Launch our XPart child.
    m_partProcess = new TDEProcess;
    *m_partProcess << "./xp_notepad"
                   << kapp->dcopClient()->appId() << m_host->objId();
    m_partProcess->start();

    // Init our Gui
    (void) new TDEAction( "Hop", 0, this, TQT_SLOT(hop()), actionCollection(), "hop" );
    KStdAction::quit( this, TQT_SLOT( close() ), actionCollection() );
    TDESelectAction *s = new TDESelectAction( "http://www.kde.org" , 0,
                                          actionCollection(), "location" );
    connect( s, TQT_SIGNAL(activated( const TQString& ) ), this, TQT_SLOT( slotOpenUrl( const TQString & ) ) );
    s->setEditable(true);

    kdDebug() << "KShell window created" << endl;
}

ShellWindow::~ShellWindow()
{
    delete m_partProcess;
}

void ShellWindow::hop()
{
    kdDebug() << "hop called!" << endl;
}

void ShellWindow::slotOpenUrl( const TQString &url )
{
    kdDebug() << "this=" << this;
    kdDebug() << "url=" << url << endl;
    m_host->openURL(url.latin1());
}

void ShellWindow::mergeGUI()
{
    tqDebug("initGUI");
    setXMLFile("shell_xparthost.rc");
    createGUI( m_host );
    m_host->widget()->setFocus();
    kdDebug() << "focus set to embedded widget" << endl;
}

int main( int argc, char **argv )
{
    TDEApplication app( argc, argv, "xparthost_shell" );

    app.dcopClient()->registerAs("xparthost_shell");

    ShellWindow *w = new ShellWindow;
    w->resize(500, 500);
    w->show();

    return app.exec();
}

#include "shell_xparthost.moc"
