#include "kbrowsersignals.h"
#include "xparthost_kpart.h"
#include "xbrowserextension_stub.h"
#include <kurl.h>

KBrowserSignals::KBrowserSignals( XPartHost_KPart *_part, DCOPRef extension )
    : KParts::BrowserExtension( _part )
{
    tqDebug("KBrowserSignals constructor");
    part = _part;
    ext = new XBrowserExtension_stub( extension.app(), extension.object() );
    ext->setBrowserSignals( DCOPRef( this ) );
}

KBrowserSignals::~KBrowserSignals()
{
    delete ext;
}

void KBrowserSignals::openURLRequest( const TQCString &url)
{
    KURL u = TQString(url);
    emit KParts::BrowserExtension::openURLRequest(u);
}

void KBrowserSignals::createNewWindow( const TQCString &url )
{
}

#include "kbrowsersignals.moc"

