import org.trinitydesktop.qt.*;
import org.trinitydesktop.koala.*;

/**
 *  Class KHelpers is the main application window.
 *
 *  Taken from KDE 2.0 Development book
 *
 *  ToolTips, What's This?, and More
 *
 *
 *
 * @see TDEMainWindow
 * @see TDEApplication
 *
 * @author java translation Kenneth J. Pouncey, kjpou@hotmail.com
 * @version 0.1
 */

public class KHelpers extends TDEMainWindow {

   // File menu item id's
   protected int idfilenew;
   protected int idfileopen;
   protected int idfilesave;
   protected int idfilequit;

   // reference to the application
   TDEApplication kapp;

   // time to display the message in the status bar
   int HelpMessageTime = 200;

   public KHelpers () {

      // get a reference to the application
      kapp = TDEApplication.kApplication();

      TQPopupMenu file = new TQPopupMenu(this);

      idfilenew = file.insertItem("&New");
      idfileopen = file.insertItem("&Open...");
      idfilesave = file.insertItem("&Save");
      idfilequit = file.insertItem("&Quit", kapp, SLOT("closeAllWindows()"));

      connect ( file, SIGNAL( "highlighted(int)"), this, SLOT( "slotMenuEntryHelp (int)"));

      menuBar().insertItem("&File",file);

      TQPopupMenu help = helpMenu("KHelpers\n" +
                                    "Copyright (C) 2000 By Joe Developer\n\n" +
                                    "KHelpers demonstates a few of the ways " +
                                    "that your application can provide help to a user");

      help.insertSeparator();
      help.insertItem("Help on a special topic", this, SLOT("slotSpecialHelp()"));

      menuBar().insertItem("&Help",help);

      // Create the statusbar
      statusBar();

      TQLabel clientarea = new TQLabel(this);
      clientarea.setBackgroundColor(Qt.white());

      TQToolTip.add(clientarea, "Functionless client area");
      TQWhatsThis.add(clientarea,"This client area doesn't do anything.");

      setCentralWidget(clientarea);

      clientarea.setFocus();
   }

   public void slotMenuEntryHelp (int id) {

      if (id == idfilenew) {
         statusBar().message("Create a new document.",HelpMessageTime);
      }
      else if (id == idfileopen) {

         statusBar().message("Open a file.",HelpMessageTime);

      }
      else if (id == idfilesave) {

         statusBar().message("Save the current document.",HelpMessageTime);

      }
      else if (id == idfilequit) {

         statusBar().message("Quit the application.",HelpMessageTime);

      }
   }

   public void slotSpecialHelp() {

      String helpfilename = kapp.name();
      helpfilename += "/specialhelp.html";
      kapp.invokeHelp(helpfilename,"");
   }

}
