//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.QtSupport;

/**

 This namespace provides a method for issuing events to a KNotifyServer
 call KNotifyClient.event("eventname"); to issue it.
 On installation, there should be a file called
 $TDEDIR/share/apps/appname/eventsrc which contains the events.
 The file looks like this:
 <pre>
 [!Global!]
 IconName=Filename (e.g. kdesktop, without any extension)
 Comment=FriendlyNameOfApp
 [eventname]
 Name=FriendlyNameOfEvent
 Comment=Description Of Event
 default_sound=filetoplay.wav
 default_logfile=logfile.txt
 default_commandline=command
 default_presentation=1
  ...
 </pre>
 default_presentation contains these ORed events:
	None=0, Sound=1, Messagebox=2, Logfile=4, Stderr=8, PassivePopup=16,
      Execute=32, Taskbar=64
 KNotify will search for sound files given with a relative path first in
 the application's sound directory (share/apps/Application Name/sounds), then in
 the KDE global sound directory (share/sounds).
 You can also use the "nopresentation" key, with any the presentations
 ORed.  Those that are in that field will not appear in the kcontrol
 module.  This was intended for software like KWin to not allow a window-opening
 that opens a window (e.g., allowing to disable KMessageBoxes from appearing)
 If the user edits the eventsrc file manually, it will appear.  This only
 affects the KcmNotify.
 You can also use the following events, which are system controlled
 and do not need to be placed in your eventsrc:
<ul>
 <li>cannotopenfile
 <li>notification
 <li>warning
 <li>fatalerror
 <li>catastrophe
</ul>
 The events can be configured in an application using KNotifyDialog, which is part of TDEIO.
		@author Charles Samuels <charles@kde.org>

		@short    This namespace provides a method for issuing events to a KNotifyServer  call KNotifyClient.event("eventname"); to issue it.

*/
public class KNotifyClient {
	/**
		 Describes the notification method.
		     		@short    Describes the notification method.
	*/
	public static final int Default = -1;
	public static final int None = 0;
	public static final int Sound = 1;
	public static final int Messagebox = 2;
	public static final int Logfile = 4;
	public static final int Stderr = 8;
	public static final int PassivePopup = 16;
	public static final int Execute = 32;
	public static final int Taskbar = 64;

	/**
		 Describes the level of the error.
			 		@short    Describes the level of the error.
	*/
	public static final int Notification = 1;
	public static final int Warning = 2;
	public static final int Error = 4;
	public static final int Catastrophe = 8;

	/**
		 default events you can use
			 		@short    default events you can use
	*/
	public static final int cannotOpenFile = 0;
	public static final int notification = 1;
	public static final int warning = 2;
	public static final int fatalError = 3;
	public static final int catastrophe = 4;

	/**
		 This starts the KNotify Daemon, if it's not already started.
		 This will be useful for games that use sound effects. Run this
		 at the start of the program, and there won't be a pause when it is
		 first triggered.
				@return true if daemon is running (always true at the moment)

		@short    This starts the KNotify Daemon, if it's not already started.
	*/
	public static native boolean startDaemon();
	/**
		 This should be the most used method in here.
		 Pass the origin-widget's winId() here so that a PassivePopup can be
		 placed appropriately.
			 Call it by KNotifyClient.event(widget.winId(), "EventName");
		 It will use TDEApplication.kApplication.dcopClient() to communicate to
		 the server
			@param winId The winId() of the widget where the event originates
			@param message The name of the event
			@param text The text to put in a dialog box.  This won't be shown if
		             the user connected the event to sound, only. Can be null.
				@return a value > 0, unique for this event if successful, 0 otherwise

		@short    This should be the most used method in here.
	*/
	public static native int event(int winId, String message, String text);
	public static native int event(int winId, String message);
	/**
		 You should
		 pass the origin-widget's winId() here so that a PassivePopup can be
		 placed appropriately.
			@param winId The winId() of the widget where the event originates
			@param event The event you want to raise
			@param text The text to put in a dialog box.  This won't be shown if
		             the user connected the event to sound, only. Can be null.
				@return a value > 0, unique for this event if successful, 0 otherwise

		@short    You should  pass the origin-widget's winId() here so that a PassivePopup can be  placed appropriately.
	*/
	public static native int event(int winId, int event, String text);
	public static native int event(int winId, int event);
	/**
		 Will fire an event that's not registered.
		 You should
		 pass the origin-widget's winId() here so that a PassivePopup can be
		 placed appropriately.
			@param winId The winId() of the originating widget
			@param text The error message text, if applicable
			@param present The presentation method(s) of the event
			@param level The error message level, defaulting to "Default"
			@param sound The sound file to play if selected with <code>present</code>
			@param file The log file to append the message to if selected with <code>present</code>
				@return a value > 0, unique for this event if successful, 0 otherwise

		@short    Will fire an event that's not registered.
	*/
	public static native int userEvent(int winId, String text, int present, int level, String sound, String file);
	public static native int userEvent(int winId, String text, int present, int level, String sound);
	public static native int userEvent(int winId, String text, int present, int level);
	public static native int userEvent(int winId, String text, int present);
	public static native int userEvent(int winId, String text);
	public static native int userEvent(int winId);
	/**
		 This is a simple substitution for TQApplication.beep().
		 It simply calls
		 <pre>
		 KNotifyClient.event( KNotifyClient.notification, reason );
		 </pre>
			@param reason the reason, can be null.
			 		@short    This is a simple substitution for TQApplication.beep().
	*/
	public static native void beep(String reason);
	public static native void beep();
	/**
		 Gets the presentation associated with a certain event name
		 Remeber that they may be ORed:
		 <pre>
		 if (present & KNotifyClient.Sound) { [Yes, sound is a default] }
		 </pre>
			@param eventname the event name to check
				@return the presentation methods

		@short    Gets the presentation associated with a certain event name  Remeber that they may be ORed:  <pre>  if (present & KNotifyClient.Sound) { [Yes, sound is a default] }	  </pre>
	*/
	public static native int getPresentation(String eventname);
	/**
		 Gets the default file associated with a certain event name
		 The control panel module will list all the event names
		 This has the potential for being slow.
			@param eventname the name of the event
			@param present the presentation method
				@return the associated file. Can be null if not found.

		@short    Gets the default file associated with a certain event name  The control panel module will list all the event names  This has the potential for being slow.
	*/
	public static native String getFile(String eventname, int present);
	/**
		 Gets the default presentation for the event of this program.
		 Remember that the Presentation may be ORed.  Try this:
		 <pre>
		 if (present & KNotifyClient.Sound) { [Yes, sound is a default] }
		 </pre>
				@return the presentation methods

		@short    Gets the default presentation for the event of this program.
	*/
	public static native int getDefaultPresentation(String eventname);
	/**
		 Gets the default File for the event of this program.
		 It gets it in relation to present.
		 Some events don't apply to this function ("Message Box")
		 Some do (Sound)
			@param eventname the name of the event
			@param present the presentation method
				@return the default file. Can be null if not found.

		@short    Gets the default File for the event of this program.
	*/
	public static native String getDefaultFile(String eventname, int present);
	/**
		 Shortcut to KNotifyClient.Instance.current() :)
				@return the current TDEInstance.

		@short    Shortcut to KNotifyClient.Instance.current() :)
	*/
	public static native TDEInstanceInterface instance();
}
