import java.util.*;

import org.trinitydesktop.qt.*;
import org.trinitydesktop.koala.*;

/**
  * The base class for JavaApiTest application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KBaseView creates your center view, which is connected
  * to the window's Doc object.
  * KBase reimplements the methods that TDEMainWindow provides for main window handling and supports
  * full session management as well as using TDEActions.
  * @see TDEMainWindow
  * @see TDEApplication
  * @see TDEConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
public class KPenBrushDlg extends TQDialog {

   private TQSpinBox width_spbox;
   private TQLabel width_label;
   private TQPushButton default_btn;
   private TQPushButton ok_btn;
   private TQPushButton cancel_btn;

   public KPenBrushDlg(int curr, TQWidget parent, String name) {
      super (parent,name,true,WStyle_ContextHelp);
      initDialog();
      TQWhatsThis.add(width_spbox,i18n("Select brush width"));

      width_spbox.setValue(curr);
      connect(default_btn, SIGNAL("clicked()"), this, SLOT("slotDefault()"));
      connect(ok_btn, SIGNAL("clicked()"), this, SLOT("accept()"));
      connect(cancel_btn, SIGNAL("clicked()"), this, SLOT("reject()"));


   }

   int getPenWidth() {
      return width_spbox.value();
   };

   void  initDialog(){
     this.resize(370,210);
     this.setMinimumSize(0,0);
     width_spbox= new TQSpinBox(this,"width_spbox");
     width_spbox.setGeometry(150,50,100,25);
     width_spbox.setMinimumSize(0,0);
     width_spbox.setValue(1);
     width_spbox.setRange(1,99);

     width_label= new TQLabel(this,"width_label");
     width_label.setGeometry(20,50,120,25);
     width_label.setMinimumSize(0,0);
     width_label.setText(i18n("Pen width:"));

     default_btn= new TQPushButton(this,"default");
     default_btn.setGeometry(30,160,100,30);
     default_btn.setMinimumSize(0,0);
     default_btn.setText(i18n("&Default"));
     default_btn.setAutoDefault(true);

     ok_btn= new TQPushButton(this,"ok");
     ok_btn.setGeometry(140,160,100,30);
     ok_btn.setMinimumSize(0,0);
     ok_btn.setText(i18n("&OK"));
     ok_btn.setAutoDefault(true);

     cancel_btn= new TQPushButton(this,"cancel");
     cancel_btn.setGeometry(250,160,100,30);
     cancel_btn.setMinimumSize(0,0);
     cancel_btn.setText(i18n("&Cancel"));
     cancel_btn.setAutoDefault(true);

   }

   void slotDefault(){
     width_spbox.setValue(3);
   }
}
