// Qt# tutorial 7
// Based on the Qt tutorial
// Implemented by Marcus Urban
//
// This example currently does not funtion properly because custom
// signals are not yet implemented.

using System;
using Qt;

[DeclareQtSignal ("valueChanged(int)")]
public class LCDRange : TQVBox {

	TQSlider slider;

	public LCDRange (TQWidget parent, String name) : base (parent, name)
	// In C++, parent and name have default values of 0 (null pointer)
	{
		TQLCDNumber lcd = new TQLCDNumber (2, this, "lcd" );
		slider = new TQSlider (Orientation.Horizontal, this, "slider");
		slider.SetRange (0, 99);
		slider.SetValue (0);

		Connect ( slider, TQT_SIGNAL ("valueChanged(int)"), lcd, TQT_SLOT ("Display(int)") );
		Connect ( slider, TQT_SIGNAL ("valueChanged(int)"), TQT_SIGNAL ("valueChanged(int)"));
	}

	public LCDRange (TQWidget parent) : this (parent, "") {}
	public LCDRange () : this (null, "") {}
	// Note that it was necessary to use an empty string ("")
	// in the above. Using null does not work at runtime.

	public void SetValue (int value)
	{
		slider.SetValue (value);
	}
}

public class MyWidget : TQVBox {

	MyWidget (TQWidget parent, String name) : base (parent, name)
	{
		TQPushButton quit = new TQPushButton ("Quit", this, "quit");
		quit.SetFont ( new TQFont ("Times", 18, TQFont.Weight.Bold) );
		
		Connect ( quit, TQT_SIGNAL ("clicked()"), tqApp, TQT_SLOT ("Quit()") );
		
		TQGrid grid = new TQGrid (4, this);
		
		LCDRange previous = null;
		
		for ( int c =0; c < 4; c++ ) {
			for ( int r = 0; r < 4; r++ ) {
				LCDRange lr = new LCDRange (grid);
				if (previous != null)
					Connect (lr, TQT_SIGNAL ("valueChanged(int)"),
						previous, TQT_SLOT ("SetValue(int)") );
				previous = lr;
			}
		}
	}
	
	public MyWidget (TQWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
}

public class Example {

	public static int Main (String[] args)
	{
		TQApplication a = new TQApplication (args);

		MyWidget w = new MyWidget ();
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
