// Qt# tutorial 4
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class MyWidget : TQWidget {

	public MyWidget (TQWidget parent, String name) : base (parent, name)
	// In C++, parent and name have default values of 0 (null pointer)
	{
		this.SetMinimumSize (200, 120);
		this.SetMaximumSize (200, 120);
		
		TQPushButton quit = new TQPushButton ("Quit", this, "quit");
		quit.SetGeometry (62, 40, 75, 30);
		quit.SetFont (new TQFont ("Times", 18, TQFont.Weight.Bold) );
		
		Connect ( quit, TQT_SIGNAL ("clicked()"), tqApp, TQT_SLOT ("Quit()") );
		// In C++, tqApp is a global variable. Here it's a property of the TQObject
		// class, which we inherit, giving the same effect. We also inherit the
		// static method connect().
	}
	
	public MyWidget (TQWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
	// Note that it was necessary to use an empty string ("")
	// in the above. Using null does not work at runtime.
}

public class Example {

	public static int Main (String[] args)
	{
		TQApplication a = new TQApplication (args);
		
		MyWidget w = new MyWidget ();
		w.SetGeometry (100, 100, 200, 120);
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
