import org.trinitydesktop.qt.*;

public class Tut8 extends TQWidget {
	public Tut8() {
		TQPushButton quit = new TQPushButton("Quit", this, "quit");
		quit.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(quit, SIGNAL("clicked()"), tqApp(), SLOT("quit()"));

		LCDRange angle = new LCDRange(this, "angle");
		angle.setRange(5, 70);

		CannonField cannonField = new CannonField(this, "cannonField");

		connect(angle, SIGNAL("valueChanged(int)"),
						cannonField, SLOT("setAngle(int)"));
		connect(cannonField, SIGNAL("angleChanged(int)"),
						angle, SLOT("setValue(int)"));

		TQGridLayout grid = new TQGridLayout(this, 2, 2, 10, -1, null);
		//2x2, 10 pixel border

		grid.addWidget(quit, 0, 0);
		grid.addWidget(angle, 1, 0, Qt.AlignTop);
		grid.addWidget(cannonField, 1, 1);
		grid.setColStretch(1, 10);

		angle.setValue(60);
		angle.setFocus();
	}
	
	public static void main(String[] args) {
		TQApplication a = new TQApplication(args);
		Tut8 w = new Tut8();
		w.setGeometry( 100, 100, 500, 355 );
		
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.trinitydesktop.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
