/***************************************************************************
* $Id$
**
* Definition of something or other
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;

class Frame extends TQFrame
{

private     TQPushButton button1;
private     TQPushButton button2;
     
private     TQFrame popup1;
private     FancyPopup popup2;

Frame()
{
	this(null, null);
}

Frame(TQWidget parent, String name)
{
    super(parent, name);
    button1 = new TQPushButton("Simple Popup", this);
    connect ( button1, SIGNAL(" clicked()"), SLOT(" button1Clicked()") );
    button2 = new TQPushButton("Fancy Popup", this);
    connect ( button2, SIGNAL(" pressed()"), SLOT(" button2Pressed()") );

    TQBoxLayout  l = new TQHBoxLayout( this );
    button1.setMaximumSize(button1.sizeHint());
    button2.setMaximumSize(button2.sizeHint());
    l.addWidget( button1 );
    l.addWidget( button2 );
    l.activate();

//     button1.setGeometry(20,20,100,30);
//     button2.setGeometry(140,20,100,30);
    resize(270, 70);

    //create a very simple popup: it is just composed with other
    //widget and will be shown after clicking on button1

    popup1 = new TQFrame( this ,null, WType_Popup);
    popup1.setFrameStyle( WinPanel|Raised );
    popup1.resize(150,100);
    TQLineEdit tmpE = new TQLineEdit( popup1 );
    connect( tmpE, SIGNAL(" returnPressed()"), popup1, SLOT(" hide()") );
    tmpE.setGeometry(10,10, 130, 30);
    tmpE.setFocus();
    TQPushButton tmpB = new TQPushButton("Click me!", popup1);
    connect( tmpB, SIGNAL(" clicked()"), popup1, SLOT(" close()") );
    tmpB.setGeometry(10, 50, 130, 30);

    // the fancier version uses its own class. It will be shown when
    // pressing button2, so they behavior is more like a modern menu
    // or toolbar.

   popup2 = new FancyPopup( this );

    // you might also add new widgets to the popup, just like you do
    // it with any other widget.  The next four lines (if not
    // commented out) will for instance add a line edit widget.

//     tmpE = new TQLineEdit( popup2 );
//     tmpE.setFocus();
//     connect( tmpE, SIGNAL(" returnPressed()"), popup2, SLOT(" close()") );
//     tmpE.setGeometry(10, 10, 130, 30);
}


void button1Clicked(){
    popup1.move( mapToGlobal( button1.geometry().bottomLeft() ) );
    popup1.show();
}

void button2Pressed(){
    popup2.popup(button2);
}

class FancyPopup  extends TQLabel
{
private    TQWidget popupParent;
private    int moves;



FancyPopup( TQWidget parent )
{
	this(parent, null);
}

FancyPopup( TQWidget parent, String  name )
{
    super( parent, name, WType_Popup );
        setFrameStyle( WinPanel|Raised );
        setAlignment( AlignCenter );
        resize(150,100);
        moves = 0;
        setMouseTracking( true );
}

protected void mouseMoveEvent( TQMouseEvent  e){
    moves++;
    String s = e.pos().x() + "/" + e.pos().y();
    if ((e.state() & TQMouseEvent.LeftButton) != 0)
        s += " (down)";
    setText(s);
}

protected void mouseReleaseEvent( TQMouseEvent  e){
    if  (rect().contains( e.pos() ) || moves > 5)
        close();
}

protected void closeEvent( TQCloseEvent e ){
    e.accept();
    moves = 0;
    if (popupParent == null)
        return;

    // remember that we (as a popup) might recieve the mouse release
    // event instead of the popupParent. This is due to the fact that
    // the popupParent popped us up in its mousePressEvent handler. To
    // avoid the button remaining in pressed state we simply send a
    // faked mouse button release event to it.
    TQMouseEvent me = new TQMouseEvent( TQEvent.MouseButtonRelease, new TQPoint(0,0), new TQPoint(0,0), TQMouseEvent.LeftButton, TQMouseEvent.NoButton);
    TQApplication.sendEvent( popupParent, me );
}

void popup( TQWidget parent) {
    popupParent = parent;
    setText("Move the mouse!");
    if (popupParent != null)
        move( popupParent.mapToGlobal( popupParent.rect().bottomLeft() ) );
    show();
}

}


public static void main(String[] args)
{
    TQApplication a = new TQApplication( args );

    Frame frame = new Frame();
    frame.setCaption("Qt Example - Custom Popups");
    a.setMainWidget(frame);
    frame.show();
    a.exec();
    return;
}

	static {
		qtjava.initialize();
	}
}
