/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;

class MenuExample  extends TQWidget
{

private    TQMenuBar menu;
private    TQLabel   label;
private    boolean isBold;
private    boolean isUnderline;
private    int boldID, underlineID;



/* XPM */
static String  p1_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFF0000",
"                ",
"                ",
"         ....   ",
"        .XXXX.  ",
" .............. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .............. ",
"                "};

/* XPM */
static String  p2_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"   ......       ",
"   .XXX.X.      ",
"   .XXX.XX.     ",
"   .XXX.XXX.    ",
"   .XXX.....    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .........    ",
"                ",
"                "};

/* XPM */
static String  p3_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"                ",
"   .........    ",
"  ...........   ",
"  ........ ..   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"   .........    ",
"                ",
"                "};


/*
  Auxiliary class to provide fancy menu items with different
  fonts. Used for the "bold" and "underline" menu items in the options
  menu.
 */
/**
class MyMenuItem  extends TQCustomMenuItem
{
private    String string;
private    TQFont font;

    public    MyMenuItem( String s, TQFont f )
    {
	    font = f;
    	string = s;
	}

    public void paint( TQPainter p, TQColorGroup cg, boolean act, boolean enabled, int x, int y, int w, int h )
    {
	p.setFont ( font );
	p.drawText( x, y, w, h, AlignLeft | AlignVCenter | ShowPrefix | DontClip, string );
    }

    public TQSize sizeHint()
    {
	return new TQFontMetrics( font ).size( AlignLeft | AlignVCenter | ShowPrefix | DontClip,  string );
    }
}
*/

MenuExample( )
{
	this(null, null);
}

MenuExample( TQWidget parent, String name )
{
    super( parent, name );
    TQPixmap p1 = new TQPixmap( p1_xpm );
    TQPixmap p2 = new TQPixmap( p2_xpm );
    TQPixmap p3 = new TQPixmap( p3_xpm );

    TQPopupMenu print = new TQPopupMenu( this );
    print.insertTearOffHandle();
    print.insertItem( "&Print to printer", this, SLOT("printer()") );
    print.insertItem( "Print to &file", this, SLOT("file()") );
    print.insertItem( "Print to fa&x", this, SLOT("fax()") );
    print.insertSeparator();
    print.insertItem( "Printer &Setup", this, SLOT("printerSetup()") );

    TQPopupMenu file = new TQPopupMenu( this );
    file.insertItem( new TQIconSet(p1), "&Open",  this, SLOT("open()"), new TQKeySequence(CTRL+Key_O) );
    file.insertItem( new TQIconSet(p2), "&New", this, SLOT("news()"), new TQKeySequence(CTRL+Key_N) );
    file.insertItem( new TQIconSet(p3), "&Save", this, SLOT("save()"), new TQKeySequence(CTRL+Key_S) );
    file.insertItem( "&Close", this, SLOT("closeDoc()"), new TQKeySequence(CTRL+Key_W) );
    file.insertSeparator();
    file.insertItem( "&Print", print, CTRL+Key_P );
    file.insertSeparator();
    file.insertItem( "E&xit",  tqApp(), SLOT("quit()"), new TQKeySequence(CTRL+Key_Q) );

    TQPopupMenu edit = new TQPopupMenu( this );
    int undoID = edit.insertItem( "&Undo", this, SLOT("undo()") );
    int redoID = edit.insertItem( "&Redo", this, SLOT("redo()") );
    edit.setItemEnabled( undoID, false );
    edit.setItemEnabled( redoID, false );

    TQPopupMenu options = new TQPopupMenu( this );
    options.insertTearOffHandle();
    options.setCaption("Options");
    options.insertItem( "&Normal Font", this, SLOT("normal()") );
    options.insertSeparator();

    options.polish(); // adjust system settings
    TQFont f = options.font();
    f.setBold( true );
//    boldID = options.insertItem( new MyMenuItem( "&Bold", f ) );
    options.setAccel( new TQKeySequence(CTRL+Key_B), boldID );
    options.connectItem( boldID, this, SLOT("bold()") );
    f = font();
    f.setUnderline( true );
//    underlineID = options.insertItem( new MyMenuItem( "&Underline", f ) );
    options.setAccel( new TQKeySequence(CTRL+Key_U), underlineID );
    options.connectItem( underlineID, this, SLOT("underline()") );

    isBold = false;
    isUnderline = false;
    options.setCheckable( true );


    TQPopupMenu help = new TQPopupMenu( this );
    help.insertItem( "&About", this, SLOT("about()"), new TQKeySequence(CTRL+Key_H) );
    help.insertItem( "About &Qt", this, SLOT("aboutTQt()") );

    menu = new TQMenuBar( this );
    menu.insertItem( "&File", file );
    menu.insertItem( "&Edit", edit );
    menu.insertItem( "&Options", options );
    menu.insertSeparator();
    menu.insertItem( "&Help", help );
    menu.setSeparator( TQMenuBar.InWindowsStyle );

    label = new TQLabel( this );
    label.setGeometry( 20, rect().center().y()-20, width()-40, 40 );
    label.setFrameStyle( TQFrame.Box | TQFrame.Raised );
    label.setLineWidth( 1 );
    label.setAlignment( AlignCenter );

    connect( this,  SIGNAL("explain(String)"),
	     label, SLOT("setText(String)") );

    setMinimumSize( 100, 80 );
}


void open()
{
    emit("explain", "File/Open selected" );
}


void news()
{
    emit("explain", "File/New selected" );
}

void save()
{
    emit("explain", "File/Save selected" );
}


void closeDoc()
{
    emit("explain", "File/Close selected" );
}


void undo()
{
    emit("explain", "Edit/Undo selected" );
}


void redo()
{
    emit("explain", "Edit/Redo selected" );
}


void normal()
{
    isBold = false;
    isUnderline = false;
    menu.setItemChecked( boldID, isBold );
    menu.setItemChecked( underlineID, isUnderline );
    emit("explain", "Options/Normal selected" );
}


void bold()
{
    isBold = !isBold;
    menu.setItemChecked( boldID, isBold );
    emit("explain", "Options/Bold selected" );
}


void underline()
{
    isUnderline = !isUnderline;
    menu.setItemChecked( underlineID, isUnderline );
    emit("explain", "Options/Underline selected" );
}


void about()
{
    TQMessageBox.about( this, "Qt Menu Example",
			"This example demonstrates simple use of Qt menus.\n"
			+ "You can cut and paste lines from it to your own\n"
			+ "programs." );
}


void aboutTQt()
{
    TQMessageBox.aboutTQt( this, "Qt Menu Example" );
}


void printer()
{
    emit("explain", "File/Printer/Print selected" );
}

void file()
{
    emit("explain", "File/Printer/Print To File selected" );
}

void fax()
{
    emit("explain", "File/Printer/Print To Fax selected" );
}

void printerSetup()
{
    emit("explain", "File/Printer/Printer Setup selected" );
}


protected void resizeEvent( TQResizeEvent e  )
{
    label.setGeometry( 20, rect().center().y()-20, width()-40, 40 );
}


public static void main(String[] args)
{
    TQApplication a = new TQApplication( args );
    MenuExample m = new MenuExample();
    m.setCaption("Qt Examples - Menus");
    a.setMainWidget( m );
    m.show();
    a.exec();
    return;
}

	static {
		qtjava.initialize();
	}

}
