/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;
import java.util.*;


class HelpWindow extends TQMainWindow
{
private   TQTextBrowser browser;
private   TQComboBox pathCombo;
private   int backwardId, forwardId;
private   String selectedURL;
private   ArrayList history = new ArrayList();
private   ArrayList bookmarks = new ArrayList();
private   HashMap mHistory = new HashMap();
private   HashMap mBookmarks = new HashMap();
private   TQPopupMenu hist, bookm;




HelpWindow( String home_, String _path )
{
	this(home_, _path, null, null);
}

HelpWindow( String home_, String _path,
			TQWidget parent, String name )
{
    super( parent, name, WDestructiveClose );
    readHistory();
    readBookmarks();

    browser = new TQTextBrowser( this );

    browser.mimeSourceFactory().setFilePath( new String[] { _path } );
    browser.setFrameStyle( TQFrame.Panel | TQFrame.Sunken );
    connect( browser, SIGNAL(" textChanged()"),
	     this, SLOT(" textChanged()") );

    setCentralWidget( browser );

    if ( !home_.equals("") )
	browser.setSource( home_ );

    connect( browser, SIGNAL(" highlighted( String)"),
	     statusBar(), SLOT(" message( String)") );

    resize( 640,700 );

    TQPopupMenu file = new TQPopupMenu( this );
    file.insertItem( tr("&New Window"), this, SLOT(" newWindow()"), new TQKeySequence(CTRL+Key_N) );
    file.insertItem( tr("&Open File"), this, SLOT(" openFile()"), new TQKeySequence(CTRL+Key_O) );
    file.insertItem( tr("&Print"), this, SLOT(" print()"), new TQKeySequence(CTRL+Key_P) );
    file.insertSeparator();
    file.insertItem( tr("&Close"), this, SLOT(" close()"), new TQKeySequence(CTRL+Key_Q) );
    file.insertItem( tr("E&xit"), tqApp(), SLOT(" closeAllWindows()"), new TQKeySequence(CTRL+Key_X) );

    // The same three icons are used twice each.
    TQIconSet icon_back = new TQIconSet( new TQPixmap("back.xpm") );
    TQIconSet icon_forward = new TQIconSet( new TQPixmap("forward.xpm") );
    TQIconSet icon_home = new TQIconSet( new TQPixmap("home.xpm") );

    TQPopupMenu go = new TQPopupMenu( this );
    backwardId = go.insertItem( icon_back,
				 tr("&Backward"), browser, SLOT(" backward()"),
				 new TQKeySequence(CTRL+Key_Left) );
    forwardId = go.insertItem( icon_forward,
				tr("&Forward"), browser, SLOT(" forward()"),
				new TQKeySequence(CTRL+Key_Right) );
    go.insertItem( icon_home, tr("&Home"), browser, SLOT(" home()") );

    TQPopupMenu help = new TQPopupMenu( this );
    help.insertItem( tr("&About ..."), this, SLOT(" about()") );
    help.insertItem( tr("About &Qt ..."), this, SLOT(" aboutTQt()") );

    hist = new TQPopupMenu( this );
    Iterator it = history.iterator();
	while (it.hasNext()) {
		String item = (String) it.next();
		mHistory.put(new Integer(hist.insertItem( item )), item);
	}
    connect( hist, SIGNAL(" activated( int )"),
	     this, SLOT(" histChosen( int )") );

    bookm = new TQPopupMenu( this );
    bookm.insertItem( tr( "Add Bookmark" ), this, SLOT(" addBookmark()") );
    bookm.insertSeparator();

    Iterator it2 = bookmarks.iterator();
	while (it2.hasNext()) {
		String item = (String) it2.next();
	    mBookmarks.put(new Integer(bookm.insertItem( item )), item);
	}
    connect( bookm, SIGNAL(" activated( int )"),
	     this, SLOT(" bookmChosen( int )") );

    menuBar().insertItem( tr("&File"), file );
    menuBar().insertItem( tr("&Go"), go );
    menuBar().insertItem( tr( "History" ), hist );
    menuBar().insertItem( tr( "Bookmarks" ), bookm );
    menuBar().insertSeparator();
    menuBar().insertItem( tr("&Help"), help );

    menuBar().setItemEnabled( forwardId, false);
    menuBar().setItemEnabled( backwardId, false);
    connect( browser, SIGNAL(" backwardAvailable( boolean )"),
	     this, SLOT(" setBackwardAvailable( boolean )") );
    connect( browser, SIGNAL(" forwardAvailable( boolean )"),
	     this, SLOT(" setForwardAvailable( boolean )") );


    TQToolBar toolbar = new TQToolBar( this );
    addToolBar( toolbar, "Toolbar");
    TQToolButton button;

    button = new TQToolButton( icon_back, tr("Backward"), "", browser, SLOT("backward()"), toolbar );
    connect( browser, SIGNAL(" backwardAvailable(boolean)"), button, SLOT(" setEnabled(boolean)") );
    button.setEnabled( false );
    button = new TQToolButton( icon_forward, tr("Forward"), "", browser, SLOT("forward()"), toolbar );
    connect( browser, SIGNAL(" forwardAvailable(boolean)"), button, SLOT(" setEnabled(boolean)") );
    button.setEnabled( false );
    button = new TQToolButton( icon_home, tr("Home"), "", browser, SLOT("home()"), toolbar );

    toolbar.addSeparator();

    pathCombo = new TQComboBox( true, toolbar );
    connect( pathCombo, SIGNAL(" activated( String )"),
	     this, SLOT(" pathSelected( String )") );
    toolbar.setStretchableWidget( pathCombo );
    setRightJustification( true );
    setDockEnabled( DockLeft, false );
    setDockEnabled( DockRight, false );

    pathCombo.insertItem( home_ );
    browser.setFocus();

}


void setBackwardAvailable( boolean b)
{
    menuBar().setItemEnabled( backwardId, b);
}

void setForwardAvailable( boolean b)
{
    menuBar().setItemEnabled( forwardId, b);
}


void textChanged()
{
    if ( browser.documentTitle() == null ) {
	setCaption( "Qt Example - Helpviewer - " + browser.context() );
	selectedURL = browser.context();
    }
    else {
	setCaption( "Qt Example - Helpviewer - " + browser.documentTitle() ) ;
	selectedURL = browser.documentTitle();
    }

    if ( !selectedURL.equals("") && pathCombo != null ) {
	boolean exists = false;
	int i;
	for ( i = 0; i < pathCombo.count(); ++i ) {
	    if ( pathCombo.text( i ) == selectedURL ) {
		exists = true;
		break;
	    }
	}
	if ( !exists ) {
	    pathCombo.insertItem( selectedURL, 0 );
	    pathCombo.setCurrentItem( 0 );
	    mHistory.put( new Integer(hist.insertItem( selectedURL )), selectedURL);
	} else
	    pathCombo.setCurrentItem( i );
	selectedURL = null;
    }
}

public void cleanUp()
{
    history.clear();
	Iterator it = mHistory.values().iterator();
	while (it.hasNext())
	    history.add(it.next());

    TQFile f = new TQFile( TQDir.currentDirPath() + "/.history" );
    f.open( TQIODevice.IO_WriteOnly );
    TQTextStream t = new TQTextStream( f );
	Iterator it1 = history.iterator();
	while (it1.hasNext()) {
		String item = (String) it1.next();
		t.writeRawBytes( item, item.length() );
		t.writeRawBytes( "\n", 1 );
	}
    f.close();

    bookmarks.clear();
	Iterator it3 = mBookmarks.values().iterator();
	while (it3.hasNext())
	    bookmarks.add(it3.next());

    TQFile f2 = new TQFile( TQDir.currentDirPath() + "/.bookmarks" );
    f2.open( TQIODevice.IO_WriteOnly );
    TQTextStream t2 = new TQTextStream( f2 );
	Iterator it2 = bookmarks.iterator();
	while (it2.hasNext()) {
		String item = (String) it2.next();
		t2.writeRawBytes( item, item.length() );
		t2.writeRawBytes( "\n", 1 );
	}
    f2.close();
}


void about()
{
    TQMessageBox.about( this, "HelpViewer Example",
			"<p>This example implements a simple HTML help viewer "
			+ "using Qt's rich text capabilities</p>"
			+ "<p>It's just about 100 lines of Java code, so don't expect too much :-)</p>"
			);
}


void aboutTQt()
{
    TQMessageBox.aboutTQt( this, "TQBrowser" );
}

void openFile()
{
    String fn = TQFileDialog.getOpenFileName( "", "", this );
    if ( !fn.equals("") )
	browser.setSource( fn );
}

void newWindow()
{
    ( new HelpWindow(browser.source(), "qbrowser") ).show();
}

void print()
{
    TQPrinter printer = new TQPrinter();//(TQPrinter.HighResolution );
    printer.setFullPage(true);
    if ( printer.setup( this ) ) {
	TQPainter p = new TQPainter( printer );
	TQPaintDeviceMetrics metrics = new TQPaintDeviceMetrics(p.device());
	int dpix = metrics.logicalDpiX();
	int dpiy = metrics.logicalDpiY();
	int margin = 72; // pt
	TQRect body = new TQRect(margin*dpix/72, margin*dpiy/72,
		   metrics.width()-margin*dpix/72*2,
		   metrics.height()-margin*dpiy/72*2 );
	TQFont font = new TQFont("times", 10);
	ArrayList filePaths = browser.mimeSourceFactory().filePath();
	String file = "";
	Iterator it = filePaths.iterator();
	while (it.hasNext()) {
	    file = new TQUrl( new TQUrl((String) it.next()), new TQUrl( browser.source() ).path() ).path();
	    if ( TQFile.exists( file ) )
		break;
	    else
		file = "";
	}
	if ( file.equals("") )
	    return;
	TQFile f = new TQFile( file );
	if ( !f.open( TQIODevice.IO_ReadOnly ) )
	    return;
	TQTextStream ts = new TQTextStream( f );
	TQSimpleRichText richText = new TQSimpleRichText( ts.read(), font, browser.context(), browser.styleSheet(),
				  browser.mimeSourceFactory(), body.height() );
	richText.setWidth( p, body.width() );
	TQRect view = new TQRect( body.topLeft(), body.bottomRight() );
	int page = 1;
	do {
	    richText.draw( p, body.left(), body.top(), view, colorGroup() );
	    view.moveBy( 0, body.height() );
	    p.translate( 0 , -body.height() );
	    p.setFont( font );
	    p.drawText( view.right() - p.fontMetrics().width( new Integer(page).toString() ),
			view.bottom() + p.fontMetrics().ascent() + 5, new Integer(page).toString() );
	    if ( view.top()  >= richText.height() )
		break;
	    printer.newPage();
	    page++;
	} while (true);
    }
}

void pathSelected( String _path )
{
    browser.setSource( _path );
	Iterator it = mHistory.values().iterator();
	boolean exists = false;
	while (it.hasNext()) {
	if ( ((String) it.next()).equals(_path) ) {
	    exists = true;
	    break;
	}
    }
    if ( !exists )
	mHistory.put( new Integer(hist.insertItem( _path )), _path);
}

void readHistory()
{
    if ( TQFile.exists( TQDir.currentDirPath() + "/.history" ) ) {
	TQFile f = new TQFile( TQDir.currentDirPath() + "/.history" );
	f.open( TQIODevice.IO_ReadOnly );
    TQTextStream t = new TQTextStream( f );
    while ( !t.atEnd() ) {
        String item = t.readLine();
		history.add((Object) item);
    }
	f.close();
	while ( history.size() > 20 )
	    history.remove( 0 );
    }
}

void readBookmarks()
{
    if ( TQFile.exists( TQDir.currentDirPath() + "/.bookmarks" ) ) {
	TQFile f = new TQFile( TQDir.currentDirPath() + "/.bookmarks" );
	f.open( TQIODevice.IO_ReadOnly );
    TQTextStream t = new TQTextStream( f );

    while ( !t.atEnd() ) {
        String item = t.readLine();
		bookmarks.add((Object) item);
    }
	f.close();
    }
}

void histChosen( int i )
{
    if ( mHistory.containsKey( new Integer(i) ) )
	browser.setSource( (String) mHistory.get( new Integer(i) ) );
}

void bookmChosen( int i )
{
    if ( mBookmarks.containsKey( new Integer(i) ) )
	browser.setSource( (String) mBookmarks.get( new Integer(i) ) );
}

void addBookmark()
{
    mBookmarks.put( new Integer(bookm.insertItem( caption() )), browser.context() );
}
}
