/***************************************************************************
* $Id$
**
* Ritual main() for Qt applications
**
* Copyright (C) 1996 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;

public class Main {


static DropSite addStuff( TQWidget  parent, boolean image )
{
	return addStuff(parent, image, false);
}

static DropSite addStuff( TQWidget  parent, boolean image, boolean secret )
{
    TQVBoxLayout  tll = new TQVBoxLayout( parent, 10 );
    DropSite  d = new DropSite( parent );
    d.setFrameStyle( TQFrame.Sunken + TQFrame.WinPanel );
    tll.addWidget( d );
    if ( image ) {
	TQPixmap stuff = new TQPixmap();
	if ( !stuff.load( "trolltech.bmp" ) ) {
	    stuff = new TQPixmap(20,20);
	    stuff.fill(Qt.green());
	}
	d.setPixmap( stuff );
    } else {
	d.setText("Drag and Drop");
    }
    d.setFont(new TQFont("Helvetica",18));
    if ( secret ) {
	SecretSource s = new SecretSource( (byte) 42, parent );
	tll.addWidget( s );
	d.setSecretSource( s);
    }

    TQLabel  format = new TQLabel( "\n\n\n\nNone\n\n\n\n", parent );
    tll.addWidget( format );
    tll.activate();
    parent.resize( parent.sizeHint() );

    TQObject.connect( d, Qt.SIGNAL("message(String)"),
		      format, Qt.SLOT("setText(String)") );
	return d;
}




public static void main( String[] args )
{
    TQApplication a = new TQApplication( args );

    TQWidget mw = new TQWidget();
    DropSite d1 = addStuff( mw, true );
    mw.setCaption( "Qt Example - Drag and Drop" );
    mw.show();

    TQWidget mw2 = new TQWidget();
    DropSite d2 = addStuff( mw2, false );
    mw2.setCaption( "Qt Example - Drag and Drop" );
    mw2.show();

    TQWidget mw3 = new TQWidget();
    DropSite d3 = addStuff( mw3, true, true );
    mw3.setCaption( "Qt Example - Drag and Drop" );
    mw3.show();

    TQObject.connect(Qt.qApp(),Qt.SIGNAL("lastWindowClosed()"),Qt.qApp(),Qt.SLOT("quit()"));
    a.exec();
	return;
}

static {
	qtjava.initialize();
}

}
