/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;
import java.util.*;

class CheckLists  extends TQWidget
{

protected TQListView lv1, lv2;
protected TQLabel label;

/*
  Constructor
 *
  Create all child widgets of the CheckList Widget
 */

CheckLists( )
{
	this(null, null);
}

CheckLists( TQWidget parent, String name )
{
    super( parent, name );
    TQHBoxLayout lay = new TQHBoxLayout( this );
    lay.setMargin( 5 );

    // create a widget which layouts its childs in a column
    TQVBoxLayout vbox1 = new TQVBoxLayout( lay );
    vbox1.setMargin( 5 );

    // First child: a Label
    vbox1.addWidget( new TQLabel( "Check some items!", this ) );

    // Second child: the ListView
    lv1 = new TQListView( this );
    vbox1.addWidget( lv1 );
    lv1.addColumn( "Items" );
    lv1.setRootIsDecorated( true );

    // create a list with 4 ListViewItems which will be parent items of other ListViewItems
    ArrayList parentList = new ArrayList();

    parentList.add( new TQListViewItem( lv1, "Parent Item 1" ) );
    parentList.add( new TQListViewItem( lv1, "Parent Item 2" ) );
    parentList.add( new TQListViewItem( lv1, "Parent Item 3" ) );
    parentList.add( new TQListViewItem( lv1, "Parent Item 4" ) );

    TQListViewItem item = null;
    int num = 1;
    // go through the list of parent items...
    for ( Iterator it = parentList.iterator(); it.hasNext(); num++ ) {
	item = (TQListViewItem) it.next();
	item.setOpen( true );
	// ...and create 5 checkable child ListViewItems for each parent item
	for ( int i = 1; i <= 5; i++ )
	    new TQCheckListItem( item, i + ". Child of Parent " + num, TQCheckListItem.CheckBox );
    }

    // Create another widget for layouting
    TQVBoxLayout tmp = new TQVBoxLayout( lay );
    tmp.setMargin( 5 );

    // create a pushbutton
    TQPushButton copy1 = new TQPushButton( "  ->  ", this );
    tmp.addWidget( copy1 );
    copy1.setMaximumWidth( copy1.sizeHint().width() );
    // connect the SIGNAL clicked() of the pushbutton with the SLOT copy1to2()
    connect( copy1, SIGNAL(" clicked()"), this, SLOT(" copy1to2()") );

    // another widget for layouting
    TQVBoxLayout vbox2 = new TQVBoxLayout( lay );
    vbox2.setMargin( 5 );

    // and another label
    vbox2.addWidget( new TQLabel( "Check one item!", this ) );

    // create the second listview
    lv2 = new TQListView( this );
    vbox2.addWidget( lv2 );
    lv2.addColumn( "Items" );
    lv2.setRootIsDecorated( true );

    // another widget needed for layouting only
    tmp = new TQVBoxLayout( lay );
    tmp.setMargin( 5 );

    // create another pushbutton...
    TQPushButton copy2 = new TQPushButton( "  ->  ", this );
    lay.addWidget( copy2 );
    copy2.setMaximumWidth( copy2.sizeHint().width() );
    // ...and connect its clicked() SIGNAL to the copy2to3() SLOT
    connect( copy2, SIGNAL(" clicked()"), this, SLOT(" copy2to3()") );

    tmp = new TQVBoxLayout( lay );
    tmp.setMargin( 5 );

    // and create a label which will be at the right of the window
    label = new TQLabel( "No Item yet...", this );
    tmp.addWidget( label );
}

/*
  SLOT copy1to2()
 *
  Copies all checked ListViewItems from the first ListView to
  the second one, and inserts them as Radio-ListViewItem.
 */

public void copy1to2()
{
    // create an iterator which operates on the first ListView
    Iterator it = lv1.itemList().iterator();

    lv2.clear();

    // Insert first a controller Item into the second ListView. Always if Radio-ListViewItems
    // are inserted into a Listview, the parent item of these MUST be a controller Item!
    TQCheckListItem item = new TQCheckListItem( lv2, "Controller", TQCheckListItem.Controller );
    item.setOpen( true );

    // iterate through the first ListView...
    while ( it.hasNext() ) {
		TQListViewItem current = (TQListViewItem) it.next();
	// ...check state of childs, and...
	if ( current.parent() != null )
	    // ...if the item is checked...
	    if ( ( (TQCheckListItem) current ).isOn() )
		// ...insert a Radio-ListViewItem with the same text into the second ListView
		new TQCheckListItem( item, current.text( 0 ), TQCheckListItem.RadioButton );

	}
    if ( item.firstChild() != null )
	( ( TQCheckListItem )item.firstChild() ).setOn( true );
}

/*
  SLOT copy2to3()
 *
  Copies the checked item of the second ListView into the
  Label at the right.
 */

public void copy2to3()
{
    // create an iterator which operates on the second ListView
    Iterator it = lv2.itemList().iterator();

    label.setText( "No Item checked" );

    // iterate through the second ListView...
    while ( it.hasNext() ) {
		TQListViewItem current = (TQListViewItem) it.next();
	// ...check state of childs, and...
	if ( current.parent() != null )
	    // ...if the item is checked...
	    if ( ( (TQCheckListItem) current ).isOn() )
		// ...set the text of the item to the label
		label.setText( current.text( 0 ) );
	}
}
}

