/****************************************************************************
** 
**
** Definition of TQPen class
**
** Created : 940112
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.TQPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for TQPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef TQPEN_H
#define TQPEN_H

#ifndef QT_H
#include "tqcolor.h"
#include "tqshared.h"
#endif // QT_H


class TQ_EXPORT TQPen: public Qt
{
public:
    TQPen();
    TQPen( PenStyle );
    TQPen( const TQColor &color, uint width=0, PenStyle style=SolidLine );
    TQPen( const TQColor &cl, uint w, PenStyle s, PenCapStyle c, PenJoinStyle j);
    TQPen( const TQPen & );
   ~TQPen();
    TQPen &operator=( const TQPen & );

    PenStyle	style() const		{ return data->style; }
    void	setStyle( PenStyle );
    uint	width() const		{ return data->width; }
    void	setWidth( uint );
    const TQColor &color() const		{ return data->color; }
    void	setColor( const TQColor & );
    PenCapStyle	capStyle() const;
    void	setCapStyle( PenCapStyle );
    PenJoinStyle joinStyle() const;
    void	setJoinStyle( PenJoinStyle );

    bool	operator==( const TQPen &p ) const;
    bool	operator!=( const TQPen &p ) const
					{ return !(operator==(p)); }

private:
    friend class TQPainter;
#ifdef Q_WS_WIN
    friend class TQFontEngineWin;
#endif

    TQPen	copy()	const;
    void	detach();
    void	init( const TQColor &, uint, uint );
    struct TQPenData : public TQShared {		// pen data
	PenStyle  style;
	uint	  width;
	TQColor	  color;
	TQ_UINT16  linest;
    } *data;
};


/*****************************************************************************
  TQPen stream functions
 *****************************************************************************/
#ifndef TQT_NO_DATASTREAM
TQ_EXPORT TQDataStream &operator<<( TQDataStream &, const TQPen & );
TQ_EXPORT TQDataStream &operator>>( TQDataStream &, TQPen & );
#endif

#endif // TQPEN_H
