/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <kjs/interpreter.h>

#include <kjsembed/jsconsolewidget.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/dialogfactory.h>
#include <kjsembed/factory.h>
#include <kjsembed/securitypolicy.h>

using namespace KJSEmbed;

int main( int argc, char **argv )
{
    TDEAboutData about( "test-kjsembed", I18N_NOOP("KJS Embed Test"), "0.1",
		      I18N_NOOP("Test"),
		      TDEAboutData::License_LGPL, I18N_NOOP("(c) 2001-2002 Richard Moore") );
    TDECmdLineArgs::init( argc, argv, &about );
    TDEApplication app;

    // Setup Interpreter
    KJS::Interpreter *js = Factory::defaultJS();
    KJS::Object global = js->globalObject();

    // Create Console
    JSConsoleWidget *console = new JSConsoleWidget( js );

    console->addBindings( global );
    Factory::publish( &app, js, global, "app" );
    Factory::publish( console, js, global, "console" );

    // Setup Window
    app.setMainWidget( console );
    app.connect( &app, TQT_SIGNAL( lastWindowClosed() ), TQT_SLOT(quit()) );
    console->resize( 600, 450 );
    console->show();

    return app.exec();
}
