
  

#ifndef KJSEMBED_QCanvasLine_H
#define KJSEMBED_QCanvasLine_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class TQCanvasLine;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for TQCanvasLine methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class TQCanvasLineImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasLine_1,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_setPoints_3,
       Method_startPoint_4,
       Method_endPoint_5,
       Method_rtti_6,
       Method_setPen_7,
       Method_moveBy_8,
       Method_Last = -1
   };

   TQCanvasLineImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~TQCanvasLineImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static TQCanvasLine *toTQCanvasLine( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object TQCanvasLine_1( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value setPoints_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value startPoint_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value endPoint_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rtti_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setPen_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value moveBy_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   TQCanvasLine *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasLine_H
