/*
 * main.cpp for lisa,reslisa,tdeio_lan and tdeio_rlan kcm module
 *
 *  Copyright (C) 2000,2001,2005 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tdelocale.h>
#include <kdebug.h>

#include <tqdir.h>
#include <tqdatetime.h>

#include <unistd.h>
#include <sys/types.h>

#include "kcmlisa.h"
#include "kcmreslisa.h"
#include "kcmtdeiolan.h"

extern "C"
{
  KDE_EXPORT TDECModule *create_lisa(TQWidget *parent, const char *)
  {
    return new LisaSettings("/etc/lisarc", parent);
  }
  KDE_EXPORT TDECModule *create_reslisa(TQWidget *parent, const char *)
  {
    return new ResLisaSettings(TQDir::homeDirPath()+"/.reslisarc", parent);
  }
  KDE_EXPORT TDECModule *create_tdeiolan(TQWidget *parent, const char *)
  {
    return new IOSlaveSettings("tdeio_lanrc", parent);
  }
}

