/*
    yahooconferencemessagemanager.h - Yahoo Conference Message Manager

    Copyright (c) 2003 by Duncan Mac-Vicar <duncan@kde.org>
    Copyright (c) 2005 by André Duffeck        <andre@duffeck.de>

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <kdebug.h>
#include <klineeditdlg.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <tdeconfig.h>

#include <kopetecontactaction.h>
#include <kopetecontactlist.h>
#include <kopetecontact.h>
#include <kopetechatsessionmanager.h>
#include <kopeteuiglobal.h>

#include "yahooconferencemessagemanager.h"
#include "yahoocontact.h"
#include "yahooaccount.h"
#include "yahooinvitelistimpl.h"

YahooConferenceChatSession::YahooConferenceChatSession( const TQString & yahooRoom, Kopete::Protocol *protocol, const Kopete::Contact *user,
	Kopete::ContactPtrList others, const char *name )
: Kopete::ChatSession( user, others, protocol,  name )
{

	Kopete::ChatSessionManager::self()->registerChatSession( this );
	setInstance(protocol->instance());

	connect ( this, TQT_SIGNAL( messageSent ( Kopete::Message &, Kopete::ChatSession * ) ),
			  TQT_SLOT( slotMessageSent ( Kopete::Message &, Kopete::ChatSession * ) ) );

	m_yahooRoom = yahooRoom;

	m_actionInvite = new TDEAction( i18n( "&Invite others" ), "kontact_contacts", this, TQT_SLOT( slotInviteOthers() ), actionCollection(), "yahooInvite");

	setXMLFile("yahooconferenceui.rc");
}

YahooConferenceChatSession::~YahooConferenceChatSession()
{
	emit leavingConference( this );
}

YahooAccount *YahooConferenceChatSession::account()
{
	return static_cast< YahooAccount *>( Kopete::ChatSession::account() );
}	

const TQString &YahooConferenceChatSession::room()
{
	return m_yahooRoom;
}

void YahooConferenceChatSession::joined( YahooContact *c )
{
	addContact( c );
}

void YahooConferenceChatSession::left( YahooContact *c )
{
	removeContact( c );
}

void YahooConferenceChatSession::slotMessageSent( Kopete::Message & message, Kopete::ChatSession * )
{
	kdDebug ( YAHOO_GEN_DEBUG ) << k_funcinfo << endl;

	YahooAccount *acc = dynamic_cast< YahooAccount *>( account() );
	if( acc )
		acc->sendConfMessage( this, message );
	appendMessage( message );
	messageSucceeded();
}

void YahooConferenceChatSession::slotInviteOthers()
{
	TQStringList buddies;
	TQDictIterator<Kopete::Contact> it( account()->contacts() );
	Kopete::Contact *myself = account()->myself();
	for( ; it.current(); ++it )
	{
		if( (*it) != myself && !members().contains( *it ) )
			buddies.push_back( (*it)->contactId() );
	}

	YahooInviteListImpl *dlg = new YahooInviteListImpl( Kopete::UI::Global::mainWidget() );
	TQObject::connect( dlg, TQT_SIGNAL( readyToInvite( const TQString &, const TQStringList &, const TQStringList &, const TQString & ) ), 
				account(), TQT_SLOT( slotAddInviteConference( const TQString &, const TQStringList &, const TQStringList &, const TQString & ) ) );
	dlg->setRoom( m_yahooRoom );
	dlg->fillFriendList( buddies );
	for( TQPtrList<Kopete::Contact>::ConstIterator it = members().begin(); it != members().end(); it++ )
		dlg->addParticipant( (*it)->contactId() );
	dlg->show();
}

#include "yahooconferencemessagemanager.moc"
