/*
    YahooInviteListImpl - conference invitation dialog
    
    Copyright (c) 2004 by Duncan Mac-Vicar P.    <duncan@kde.org>
    
    Kopete    (c) 2002-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "yahooinvitelistimpl.h"

#include <kdebug.h>

#include <tqlistbox.h>
#include <tqlineedit.h>

YahooInviteListImpl::YahooInviteListImpl(TQWidget *parent, const char *name) : YahooInviteListBase(parent,name)
{
	listFriends->setSelectionMode( TQListBox::Extended );
	listInvited->setSelectionMode( TQListBox::Extended );
}

YahooInviteListImpl::~YahooInviteListImpl()
{
}

void YahooInviteListImpl::setRoom( const TQString &room )
{
	kdDebug(14180) << k_funcinfo << "Setting roomname to: " << room << endl;

	m_room = room;
}

void YahooInviteListImpl::fillFriendList( const TQStringList &buddies )
{	
	kdDebug(14180) << k_funcinfo << "Adding friends: " << buddies << endl;

	m_buddyList = buddies;
	updateListBoxes();
}

void YahooInviteListImpl::updateListBoxes()
{
	kdDebug(14180) << k_funcinfo << endl;

	listFriends->clear();
	listInvited->clear();
	listFriends->insertStringList( m_buddyList );
	listFriends->sort();
	listInvited->insertStringList( m_inviteeList );
	listInvited->sort();
}

void YahooInviteListImpl::addInvitees( const TQStringList &invitees )
{
	kdDebug(14180) << k_funcinfo << "Adding invitees: " << invitees << endl;

	for( TQStringList::const_iterator it = invitees.begin(); it != invitees.end(); it++ )
	{
		if( m_inviteeList.find( *it ) == m_inviteeList.end() )
			m_inviteeList.push_back( *it );
		if( m_buddyList.find( *it ) != m_buddyList.end() )
			m_buddyList.remove( *it );
	}

	updateListBoxes();
}

void YahooInviteListImpl::removeInvitees( const TQStringList &invitees )
{
	kdDebug(14180) << k_funcinfo << "Removing invitees: " << invitees << endl;

	for( TQStringList::const_iterator it = invitees.begin(); it != invitees.end(); it++ )
	{
		if( m_buddyList.find( *it ) == m_buddyList.end() )
			m_buddyList.push_back( *it );
		if( m_inviteeList.find( *it ) != m_inviteeList.end() )
			m_inviteeList.remove( *it );
	}

	updateListBoxes();
}

void YahooInviteListImpl::addParticipant( const TQString &p )
{
	m_participants.push_back( p );
}

void YahooInviteListImpl::btnInvite_clicked()
{
	kdDebug(14180) << k_funcinfo << endl;

	if( m_inviteeList.count() )
		emit readyToInvite( m_room, m_inviteeList,m_participants, editMessage->text() );
	TQDialog::accept();
}


void YahooInviteListImpl::btnCancel_clicked()
{
	kdDebug(14180) << k_funcinfo << endl;

	TQDialog::reject();
}


void YahooInviteListImpl::btnAddCustom_clicked()
{
	kdDebug(14180) << k_funcinfo << endl;

	TQString userId;
	userId = editBuddyAdd->text();
	if( userId.isEmpty() )
		return;
	
	addInvitees( TQStringList(userId) );
	editBuddyAdd->clear();
}


void YahooInviteListImpl::btnRemove_clicked()
{
	kdDebug(14180) << k_funcinfo << endl;

	TQStringList buddies;
	for( uint i=0; i<listInvited->count(); i++ )
	{
		if (listInvited->isSelected(i))
		{
			buddies.push_back( listInvited->text(i) );
		}
	}
	removeInvitees( buddies );
}


void YahooInviteListImpl::btnAdd_clicked()
{
	kdDebug(14180) << k_funcinfo << endl;

	TQStringList buddies;
	for( uint i=0; i<listFriends->count(); i++ )
	{
		if (listFriends->isSelected(i))
		{
			buddies.push_back( listFriends->text(i) );
		}
	}
	addInvitees( buddies );
}


#include "yahooinvitelistimpl.moc"




