/*  *************************************************************************
    *   copyright: (C) 2003 Richard Lrkng <nouseforaname@home.se>         *
    *   copyright: (C) 2003 Gav Wood <gav@kde.org>                          *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqvgroupbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqpushbutton.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>

#include <tdeconfigbase.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <krestrictedline.h>

#include "kopeteuiglobal.h"

#include "smseditaccountwidget.h"
#include "smsactprefs.h"
#include "serviceloader.h"
#include "smsprotocol.h"
#include "smsaccount.h"

SMSEditAccountWidget::SMSEditAccountWidget(SMSProtocol *protocol, Kopete::Account *account, TQWidget *parent, const char */*name*/)
	: TQWidget(parent), KopeteEditAccountWidget(account)
{
	TQVBoxLayout *l = new TQVBoxLayout(this, TQBoxLayout::Down);
	preferencesDialog = new smsActPrefsUI(this);
	l->addWidget(preferencesDialog);

	service = 0L;
	configWidget = 0L;
	middleFrameLayout = 0L;

	m_protocol = protocol;

	TQString sName;
	if (account)
	{
		preferencesDialog->accountId->setText(account->accountId());
		//Disable changing the account ID for now
		//FIXME: Remove this when we can safely change the account ID (Matt)
		preferencesDialog->accountId->setDisabled(true);
		sName = account->configGroup()->readEntry("ServiceName", TQString());
		preferencesDialog->subEnable->setChecked(account->configGroup()->readBoolEntry("SubEnable", false));
		preferencesDialog->subCode->setText(account->configGroup()->readEntry("SubCode", TQString()));
		preferencesDialog->ifMessageTooLong->setCurrentItem(SMSMsgAction(account->configGroup()->readNumEntry("MsgAction", 0)));
	}

	preferencesDialog->serviceName->insertStringList(ServiceLoader::services());

	connect (preferencesDialog->serviceName, TQT_SIGNAL(activated(const TQString &)),
		this, TQT_SLOT(setServicePreferences(const TQString &)));
	connect (preferencesDialog->descButton, TQT_SIGNAL(clicked()),
		this, TQT_SLOT(showDescription()));


	for (int i=0; i < preferencesDialog->serviceName->count(); i++)
	{
		if (preferencesDialog->serviceName->text(i) == sName)
		{
			preferencesDialog->serviceName->setCurrentItem(i);
			break;
		}
	}
	setServicePreferences(preferencesDialog->serviceName->currentText());
}

SMSEditAccountWidget::~SMSEditAccountWidget()
{
	delete service;
}

bool SMSEditAccountWidget::validateData()
{
	return true;
}

Kopete::Account* SMSEditAccountWidget::apply()
{
	if (!account())
		setAccount( new SMSAccount( m_protocol, preferencesDialog->accountId->text() ) );

	if (service)
		service->setAccount(account());
	
	TDEConfigGroup *c = account()->configGroup();
	c->writeEntry("ServiceName", preferencesDialog->serviceName->currentText());
	c->writeEntry("SubEnable", preferencesDialog->subEnable->isChecked() ? "true" : "false");
	c->writeEntry("SubCode", preferencesDialog->subCode->text());
	c->writeEntry("MsgAction", preferencesDialog->ifMessageTooLong->currentItem());

	emit saved();
	return account();
}

void SMSEditAccountWidget::setServicePreferences(const TQString& serviceName)
{
	delete service;
	delete configWidget;

	service = ServiceLoader::loadService(serviceName, account());

	if (service == 0L)
		return;

	connect (this, TQT_SIGNAL(saved()), service, TQT_SLOT(savePreferences()));

	delete middleFrameLayout;
	middleFrameLayout = new TQGridLayout(preferencesDialog->middleFrame, 1, 2, 0, 6, "middleFrameLayout");
	service->setWidgetContainer(preferencesDialog->middleFrame, middleFrameLayout);
}

void SMSEditAccountWidget::showDescription()
{
	SMSService* s = ServiceLoader::loadService(preferencesDialog->serviceName->currentText(), 0L);

	TQString d = s->description();

	KMessageBox::information(Kopete::UI::Global::mainWidget(), d, i18n("Description"));
}

#include "smseditaccountwidget.moc"
