
/***************************************************************************
                   jabberbytestream.cpp  -  Byte Stream for Jabber
                             -------------------
    begin                : Wed Jul 7 2004
    copyright            : (C) 2004 by Till Gerken <till@tantalo.net>

			   Kopete (C) 2004 Kopete developers <kopete-devel@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation; either version 2.1 of the  *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#include <tqobject.h>
#include <kdebug.h>
#include "jabberbytestream.h"
#include <kbufferedsocket.h>
#include <kresolver.h>
#include "jabberprotocol.h"

JabberByteStream::JabberByteStream ( TQObject *parent, const char */*name*/ )
 : ByteStream ( parent )
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Instantiating new Jabber byte stream." << endl;

	// reset close tracking flag
	mClosing = false;

	mSocket = new KNetwork::TDEBufferedSocket;

	// make sure we get a signal whenever there's data to be read
	mSocket->enableRead ( true );

	// connect signals and slots
	TQObject::connect ( mSocket, TQT_SIGNAL ( gotError ( int ) ), this, TQT_SLOT ( slotError ( int ) ) );
	TQObject::connect ( mSocket, TQT_SIGNAL ( connected ( const KResolverEntry& ) ), this, TQT_SLOT ( slotConnected () ) );
	TQObject::connect ( mSocket, TQT_SIGNAL ( closed () ), this, TQT_SLOT ( slotConnectionClosed () ) );
	TQObject::connect ( mSocket, TQT_SIGNAL ( readyRead () ), this, TQT_SLOT ( slotReadyRead () ) );
	TQObject::connect ( mSocket, TQT_SIGNAL ( bytesWritten ( int ) ), this, TQT_SLOT ( slotBytesWritten ( int ) ) );

}

bool JabberByteStream::connect ( TQString host, TQString service )
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Connecting to " << host << ", service " << service << endl;

	mClosing = false;

	return socket()->connect ( host, service );

}

bool JabberByteStream::isOpen () const
{

	// determine if socket is open
	return socket()->isOpen ();

}

void JabberByteStream::close ()
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Closing stream." << endl;

	// close the socket and set flag that we are closing it ourselves
	mClosing = true;
	socket()->close();

}

int JabberByteStream::tryWrite ()
{

	// send all data from the buffers to the socket
	TQByteArray writeData = takeWrite();
	socket()->writeBlock ( writeData.data (), writeData.size () );

	return writeData.size ();

}

KNetwork::TDEBufferedSocket *JabberByteStream::socket () const
{

	return mSocket;

}

JabberByteStream::~JabberByteStream ()
{

	delete mSocket;

}

void JabberByteStream::slotConnected ()
{

	emit connected ();

}

void JabberByteStream::slotConnectionClosed ()
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Socket has been closed." << endl;

	// depending on who closed the socket, emit different signals
	if ( !mClosing )
	{
		emit connectionClosed ();
	}
	else
	{
		emit delayedCloseFinished ();
	}

	mClosing = false;

}

void JabberByteStream::slotReadyRead ()
{

	// stuff all available data into our buffers
	TQByteArray readBuffer ( socket()->bytesAvailable () );

	socket()->readBlock ( readBuffer.data (), readBuffer.size () );

	appendRead ( readBuffer );

	emit readyRead ();

}

void JabberByteStream::slotBytesWritten ( int bytes )
{

	emit bytesWritten ( bytes );

}

void JabberByteStream::slotError ( int code )
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Socket error " << code << endl;

	emit error ( code );

}

#include "jabberbytestream.moc"
