/**
 * Copyright (C)  2005  Jeroen Wijnhout <Jeroen.Wijnhout@kdemail.net>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TDEUNITTEST_TESTER_H_
#define _TDEUNITTEST_TESTER_H_

#include <tqlistview.h>
#include <tqhbox.h>

#include <tdeunittest/runner.h>
#include <tdeunittest/tester.h>

#include <kdemacros.h>

class TesterWidget;
class TQTextEdit;

namespace KUnitTest
{
    class RunnerGUIDCOPImpl;

    class KDE_EXPORT RunnerGUI : public TQHBox
    {
        TQ_OBJECT
  

    public:
        RunnerGUI(TQWidget *parent);
        ~RunnerGUI();
    
    private slots:
        void addTestResult(const char *name, Tester *test);
        void addTester(const char *name, Tester *test);
        void showDetails(TQListViewItem *item);
        void runSuite();
        void doubleClickedOnDetails(int para, int pos);

    private:
        void reset();
        void configureProgressBar(int steps, int progress);
        void fillResultsLabel();
        void appendList(TQTextEdit *te, const TQStringList &list);

        TQListViewItem *getItem(const TQString &name, TQListViewItem *item = 0L);
        void setItem(TQListViewItem *item, const TestResults *res);
        TQString fullName(TQListViewItem *item);

        void setSummary(TQListViewItem *item, TestResults *res);

        TesterWidget *m_testerWidget;

        friend class RunnerGUIDCOPImpl;
        RunnerGUIDCOPImpl *m_dcop;
    };
}

#endif
