/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#include "dictionarymenu.h"
#include <tdepopupmenu.h>
#include <tdeaction.h>
#include <kdebug.h>
#include <tdeshortcut.h>

#include <tqsignalmapper.h>

DictionaryMenu::DictionaryMenu(TDEPopupMenu *popupMenu, TDEActionCollection *collection
        , TQObject *parent)
              : TQObject(parent, "dictionarymenu")
              , popup(popupMenu)
              , actionCollection(collection)
	      , maxId(10)
{
   num2id.setAutoDelete(true);
   accel2id.setAutoDelete(true);

   if(popup)
   {
      connect(popup,TQT_SIGNAL(activated(int)),this,TQT_SLOT(activated(int)));
   }
   
   dictionaryMapper = new TQSignalMapper( this );
   connect( dictionaryMapper, TQT_SIGNAL( mapped( int ) ),
            this, TQT_SLOT( activated( int ) ) );

}

DictionaryMenu::~DictionaryMenu()
{
   clear();
}

void DictionaryMenu::clear()
{
   if(popup)
   {
      TQIntDictIterator<TQString> it( num2id ); // iterator for dict
      while ( it.current() )
      {
         popup->removeItem(it.currentKey());
         ++it;
      }
   }

   num2id.clear();
   
   // create new mapper
   delete dictionaryMapper;
   dictionaryMapper = new TQSignalMapper( this );
   connect( dictionaryMapper, TQT_SIGNAL( mapped( int ) ),
            this, TQT_SLOT( activated( int ) ) );
}

void DictionaryMenu::add(const TQString& name, const TQString& moduleId)
{
   if(popup)
   {
      TDEAction* dictionaryAction = new TDEAction( name, 0, dictionaryMapper, TQT_SLOT(map()), actionCollection, moduleId.utf8() );
      
      uint id = maxId++;
      dictionaryAction->plug(popup, id);

      dictionaryMapper->setMapping( dictionaryAction, id );
   
      TQString *idString = new TQString(moduleId);
      num2id.insert(id,idString);
   }
   
}

void DictionaryMenu::add(const TQString& n, const TQString& moduleId
           , const TQString& key)
{
    if(popup)
    {
        TQString name=n;
	
        TQString keyString=key;
        if(keyString.contains("%1"))
        {
            keyString=key.arg(accel2id.count()+1);
    	}
        TDEShortcut k(keyString);

    	TDEAction* dictionaryAction = new TDEAction( name, k, dictionaryMapper, TQT_SLOT(map()), actionCollection, key.arg(moduleId).utf8() );
	uint id = maxId++;
        dictionaryAction->plug(popup,id);

        if(!k.isNull())
        {
            TQString *idString = new TQString(moduleId);
            accel2id.insert(id,idString);

	    dictionaryMapper->setMapping( dictionaryAction, id );
	    
            name+='\t';
            name+=k.toString();
        }
        else
        {
            kdWarning() << "key not valid" << endl;
        }   
   
        TQString *idString = new TQString(moduleId);
        num2id.insert(id,idString);
   }
}


void DictionaryMenu::activated(int id)
{
   TQString *idString = num2id[id];
   
   if(idString)
   {
      emit activated(*idString);
   }
}

#include "dictionarymenu.moc"
