/*
	Copyright (C) 2005	Albert Cervera i Areny <albertca at hotpop dot com>

	Based on Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
		    2002 	Stanislav Visnovsky <visnovsky@kde.org>
			2003	Dwayne Bailey <dwayne@translate.org.za>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License
	along with this library; see the file COPYING.LIB.  If not, write to
	the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	Boston, MA 02110-1301, USA.
*/

#ifndef __main_h__
#define __main_h__

#include <kdatatool.h>
#include <tqvaluelist.h>

class TQDomElement;

class Expression
{
public:
	Expression() {};
	Expression( const TQString& name, const TQRegExp& regExp )
	{
		_name = name;
		_regExp = regExp;
	}
	const TQString& name() const
	{
		return _name;
	}
	const TQRegExp& regExp() const
	{
		return _regExp;
	}

private:
	TQString _name;
	TQRegExp _regExp;
};

typedef TQValueList<Expression> ExpressionList;

class RegExpTool : public KDataTool
{
	TQ_OBJECT
  

public:
	RegExpTool( TQObject* parent, const char* name, const TQStringList & );
	virtual bool run( const TQString& command, void* data, const TQString& datatype, const TQString& mimetype);
	
private:
	void loadExpressions();
	void elementToExpression( const TQDomElement& e );

	ExpressionList _list;
	TQString _error;
};

#endif
