/*
 *  Copyright (C) 2007 Dukju Ahn (dukjuahn@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 */
 
#include "kdevsvnd_widgets.h"
#include <tqpushbutton.h>
#include <tqlistview.h>
#include <tqlabel.h>
#include <tdelocale.h>

SvnSSLTrustPrompt::SvnSSLTrustPrompt( TQWidget* parent, const char* name, bool modal, WFlags f )
	:SvnSSLTrustPromptBase( parent, name, modal, f )
	, m_code(-1)
{
	listView1->setColumnText( 0, "Items" );
	listView1->setColumnText( 1, "Values" );
	btnPermanent->setText(i18n("Accept Permanently"));
	btnTemporary->setText(i18n("Accept Temporarily"));
	btnReject->setText(i18n("Reject"));
	connect( btnPermanent, TQT_SIGNAL(clicked()), this, TQT_SLOT(setPermanent()) );
	connect( btnTemporary, TQT_SIGNAL(clicked()), this, TQT_SLOT(setTemporary()) );
	connect( btnReject,    TQT_SIGNAL(clicked()), this, TQT_SLOT(setRejected ()) );
}
SvnSSLTrustPrompt::~SvnSSLTrustPrompt()
{}

void SvnSSLTrustPrompt::setupCertInfo( TQString hostname, TQString fingerPrint, TQString validfrom, TQString validuntil, TQString issuerName, TQString ascii_cert )
{
	// setup texts
	TQListViewItem *host= new TQListViewItem(listView1, i18n("Hostname"), hostname );
	TQListViewItem *finger = new TQListViewItem(listView1, i18n("FingerPrint"), fingerPrint );
	TQListViewItem *validFrom = new TQListViewItem(listView1, i18n("Valid From"), validfrom );
	TQListViewItem *validUntil = new TQListViewItem(listView1, i18n("Valid Until"), validuntil );
	TQListViewItem *issName = new TQListViewItem(listView1, i18n("Issuer"), issuerName );
	TQListViewItem *cert = new TQListViewItem(listView1, i18n("Cert"), ascii_cert );
}
void SvnSSLTrustPrompt::setupFailedReasonMsg( TQString msg )
{
	errMsgLabel->setText( msg );
}
int SvnSSLTrustPrompt::code()
{
	return m_code;
}

void SvnSSLTrustPrompt::setPermanent()
{
	m_code = 1;
}

void SvnSSLTrustPrompt::setTemporary()
{
	m_code = 0;
}

void SvnSSLTrustPrompt::setRejected()
{
	m_code = -1;
}
#include "kdevsvnd_widgets.moc"
