#include "openwithpart.h"

#include <tqfile.h>

#include <tdepopupmenu.h>
#include <kdevgenericfactory.h>
#include <kdebug.h>
#include <kmimetype.h>
#include <ktrader.h>
#include <krun.h>
#include <tdeaction.h>
#include <kcharsets.h>

#include "kdevpartcontroller.h"
#include "kdevcore.h"
#include "kdevplugininfo.h"
#include "urlutil.h"

typedef KDevGenericFactory<OpenWithPart> OpenWithFactory;

static const KDevPluginInfo data("kdevopenwith");
K_EXPORT_COMPONENT_FACTORY(libkdevopenwith, OpenWithFactory(data))

OpenWithPart::OpenWithPart(TQObject *parent, const char *name, const TQStringList &)
  : KDevPlugin(&data, parent, name ? name : "OpenWithPart")
{
  setInstance( OpenWithFactory::instance() );

  connect(core(), TQT_SIGNAL(contextMenu(TQPopupMenu*,const Context *)),
	  this, TQT_SLOT(fillContextMenu(TQPopupMenu*,const Context *)));
}


OpenWithPart::~OpenWithPart()
{
}


void OpenWithPart::fillContextMenu(TQPopupMenu *popup, const Context *context)
{
	if ( !context->hasType( Context::FileContext ) ) return;

	const FileContext *ctx = static_cast<const FileContext*>(context);
	m_urls = ctx->urls();

	popup->insertSeparator();

	popup->insertItem( i18n("Open as UTF-8"), this, TQT_SLOT(openAsUtf8()) );

	TDEPopupMenu * openAsPopup = new TDEPopupMenu( popup );

	int id = popup->insertItem( i18n("Open As"), openAsPopup );
	popup->setWhatsThis(id, i18n("<b>Open As</b><p>Lists all encodings that can be used to open the selected file."));

	TQStringList encodings = TDEGlobal::charsets()->descriptiveEncodingNames();

	int i = 0;
	TQStringList::const_iterator it = encodings.constBegin();
	while ( it != encodings.constEnd() )
	{
		openAsPopup->insertItem( *it, this, TQT_SLOT(openAsEncoding(int)), 0, i );
		++it;
		i++;
	}

	TDEPopupMenu * openWithPopup = new TDEPopupMenu( popup );

	// hmmm.. what to do here? open every different mimetype seperately? Just go with the first for now..
	TQString mimeType = KMimeType::findByURL(m_urls.first(), 0, true, true)->name();
	TDETrader::OfferList offers = TDETrader::self()->query(mimeType, "Type == 'Application'");
	if (offers.count() > 0)
	{
		TDETrader::OfferList::Iterator it;
		for (it = offers.begin(); it != offers.end(); ++it)
		{
			TDEAction *action = new TDEAction((*it)->name(), (*it)->icon(), 0, 0, TQFile::encodeName( (*it)->desktopEntryPath() ).data());
			connect(action, TQT_SIGNAL(activated()), this, TQT_SLOT(openWithService()));
			action->plug( openWithPopup );
		}
	}

	id = popup->insertItem( i18n("Open With"), openWithPopup );
	popup->setWhatsThis(id, i18n("<b>Open With</b><p>Lists all applications that can be used to open the selected file."));

	openWithPopup->insertSeparator();

	// make sure the generic "Open with ..." entry gets appended to the submenu
	id = openWithPopup->insertItem(i18n("Open With..."), this, TQT_SLOT(openWithDialog()));
	openWithPopup->setWhatsThis(id, i18n("<b>Open With...</b><p>Provides a dialog to choose the application to open the selected file."));
}


void OpenWithPart::openWithService()
{
  KService::Ptr ptr = KService::serviceByDesktopPath(sender()->name());
  if (ptr)
  {
    KRun::run(*ptr, m_urls);
  }
}


void OpenWithPart::openWithDialog()
{
  KRun::displayOpenWithDialog( m_urls );
}


void OpenWithPart::openAsEncoding( int id )
{
	TQStringList encodings = TDEGlobal::charsets()->descriptiveEncodingNames();
	TQString encoding;
	if ( id <= encodings.count() && id >= 0 )
	{
		encoding = TDEGlobal::charsets()->encodingForName( encodings[ id ] );
	}

	KURL::List::iterator it = m_urls.begin();
	while ( it != m_urls.end() )
	{
		partController()->setEncoding( encoding );
		partController()->editDocument( *it );
		++it;
	}
}

void OpenWithPart::openAsUtf8( )
{
	KURL::List::iterator it = m_urls.begin();
	while ( it != m_urls.end() )
	{
		partController()->setEncoding( "utf8" );
		partController()->editDocument( *it );
		++it;
	}
}

#include "openwithpart.moc"
