/***************************************************************************
 *   Copyright (C) 1997-2000 by Dimitri van Heesch                         *
 *   dimitri@stack.nl                                                      *
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _INPUT_H
#define _INPUT_H
 
#include <tqcheckbox.h>
#include <tqdict.h>

class TQComboBox;
class TQLabel;
class KLineEdit;
class TQListBox;
class TQPushButton;
class TQSpinBox;
 
class IInput
{
  public:
    virtual void init() = 0;
    virtual void setEnabled(bool) = 0;
    virtual TQObject *qobject() = 0;
};


class InputBool : public TQWidget, public IInput
{
    TQ_OBJECT
  

public:
    InputBool(const TQCString &key, const TQString &text, TQWidget *parent, bool &flag);
    ~InputBool();
    
    void init();
    virtual void setEnabled(bool b);
    virtual TQObject *qobject() { return TQT_TQOBJECT(this); }
    virtual bool getState() const { return state; }

signals:
    void changed();
    void toggle(const TQString &, bool);

private slots:
    void valueChanged(bool);

private:
    bool &state;
    TQCString key;
    TQCheckBox *cb;
};


class InputInt : public TQWidget, public IInput
{
    TQ_OBJECT
  

public:
    InputInt(const TQString &text, TQWidget *parent,
             int &val, int minVal, int maxVal);
    ~InputInt();
    
    void init();
    virtual void setEnabled(bool);
    TQObject *qobject() { return TQT_TQOBJECT(this); }

signals:
    void changed();

private slots:
    void valueChanged(int val); 

private:
    TQLabel *lab;
    TQSpinBox *sp;
    int &m_val;
    int m_minVal;
    int m_maxVal;
};


class InputString : public TQWidget, public IInput
{
    TQ_OBJECT
  

public:
    enum StringMode { StringFree=0, 
                      StringFile=1, 
                      StringDir=2, 
                      StringFixed=3
                    };

    InputString(const TQString &text, TQWidget *parent,
                TQCString &s, StringMode m=StringFree);
    ~InputString();
    
    void init();
    void addValue(const char *s);
    void setEnabled(bool);
    TQObject *qobject() { return TQT_TQOBJECT(this); }

signals:
    void changed();

private slots:
    void textChanged(const TQString&);
    void browse();
    void clear();

private:
    TQLabel *lab;
    KLineEdit *le;
    TQPushButton *br;
    TQComboBox *com;
    TQCString &str;
    StringMode sm;
    TQDict<int> *m_values;
    int m_index; 
};


class InputStrList : public TQWidget, public IInput
{
    TQ_OBJECT
  

public:
    enum ListMode { ListString=0, 
                    ListFile=1, 
                    ListDir=2, 
                    ListFileDir=ListFile|ListDir 
                  };
    
    InputStrList(const TQString &text, TQWidget *parent, 
                 TQStrList &sl, ListMode v=ListString);
    ~InputStrList();

    void init();
    void setEnabled(bool);
    TQObject *qobject() { return TQT_TQOBJECT(this); }

signals:
    void changed();

private slots:
    void addString(); 
    void delString(); 
    void updateString(); 
    void selectText(const TQString &s);
    void browseFiles();
    void browseDir();

private:
    TQLabel *lab;
    KLineEdit *le;
    TQPushButton *add;
    TQPushButton *del;
    TQPushButton *upd;
    TQPushButton *brFile;
    TQPushButton *brDir;
    TQListBox *lb;
    TQStrList &strList;
};

#endif
