/* This file is part of the KDE project
   Copyright (C) 2003 Alexander Dymo <cloudtemple@mksat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef TDELISTVIEWACTION_H
#define TDELISTVIEWACTION_H

#include <kxmlguiclient.h>
#include <tdeversion.h>
#include <tdeaction.h>

class KComboView;
 
/**
@file tdelistviewaction.h
Widget action with KComboView.
*/


/**
Widget action with KComboView.
Can be used on toolbars. It appears as @ref ResizableCombo.
*/
class TDEListViewAction: public KWidgetAction
{
public:
    TDEListViewAction(KComboView *view, const TQString &text, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name);
    TDEListViewAction(KComboView *view, const TQString &text, const TDEShortcut &cut, const TQObject *receiver, const char *slot, TDEActionCollection *parent, const char *name, const bool);

    ~TDEListViewAction();

    KComboView *view() const;
    void setToolTip(const TQString & str);
    void setWhatsThis(const TQString &str);

private:
    void loadComboWidth();

    KComboView *m_view;
};

#endif
