/*
 * Copyright (C) 2001 Rik Hemsley (rikkus) <rik@kde.org>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	IN NO EVENT SHALL THE
 * AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#include <tqtimer.h>

#include <noatun/app.h>
#include <noatun/player.h>
#include "seeker.h"
#include "seeker.moc"

Seeker::Seeker(TQWidget * parent)
	: TQSlider(0, 60, 10, 0,Qt::Horizontal, parent),
		adjusting_(false)
{
	delayedUpdateTimer_ = new TQTimer(this);

	connect(this, TQT_SIGNAL(sliderPressed()),		TQT_SLOT(slotSliderPressed()));
	connect(this, TQT_SIGNAL(sliderReleased()),		TQT_SLOT(slotSliderReleased()));
	connect(this, TQT_SIGNAL(valueChanged(int)),	TQT_SLOT(slotValueChanged(int)));

	connect(napp->player(),				TQT_SIGNAL(timeout()),	TQT_SLOT(slotTimeout()));
	connect(delayedUpdateTimer_,	TQT_SIGNAL(timeout()), 	TQT_SLOT(slotDelayedUpdate()));
}

Seeker::~Seeker()
{
}

	void
Seeker::slotSliderPressed()
{
	adjusting_ = true;
}

	void
Seeker::slotValueChanged(int)
{
	if (adjusting_)
		delayedUpdateTimer_->start(100, true);
}

	void
Seeker::slotDelayedUpdate()
{
	napp->player()->skipTo(value());
}

	void
Seeker::slotSliderReleased()
{
	delayedUpdateTimer_->stop();
	adjusting_ = false;
	napp->player()->skipTo(value());
}

	void
Seeker::wheelEvent(TQWheelEvent *)
{
	// Ignore.
}

	void
Seeker::slotTimeout()
{
	blockSignals(true);
	{
		delayedUpdateTimer_->stop();

		int currentLength	=	int(napp->player()->getLength());
		int currentTime		=	int(napp->player()->getTime());

		if (currentLength != maxValue())
			setMaxValue(currentLength);

		if (!adjusting_)
		{
			if (currentTime != value())
				setValue(currentTime);
		}
	}
	blockSignals(false);
	update();
}
