/**************************************************************************
			wakeup.cpp  -  alarm plugin for noatun
				------------------
		begin    : Wed Apr 11 CEST 2001
		copyright: (C) 2001 by Mickael Marchand <mikmak@freenux.org>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <noatun/engine.h>
#include <noatun/player.h>
#include <noatun/app.h>

#include <tdelocale.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqspinbox.h>
#include <tqtimer.h>
#include <tqdatetime.h>
#include <tqlayout.h>
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqwhatsthis.h>
#include <kiconloader.h>

#include <tdeconfig.h>
#include <tdeglobal.h>
#include "wakeup.h"
#include "kminutespinbox.h"
#include "kpercentspinbox.h"

extern "C"
{
	KDE_EXPORT Plugin* create_plugin()
	{
		TDEGlobal::locale()->insertCatalogue("wakeup");
		return new Wakeup();
	}
}

Wakeup *Wakeup::wakeme = 0;

Wakeup::Wakeup() : TQObject(), Plugin()
{
	wakeme = this;

	NOATUNPLUGINC(Wakeup);
	new WakeupPrefs(this);

	update();

	TQTimer *timer=new TQTimer(this);
	connect (timer,TQT_SIGNAL(timeout()),TQT_SLOT(slotCheckTime()));
	timer->start(60000,false);
}

Wakeup::~Wakeup()
{
}

void Wakeup::update()
{
	TDEConfig *config=TDEGlobal::config();
	config->setGroup("Noatun Alarm");

	hour[0]=config->readNumEntry("Hour1",7);
	minute[0]=config->readNumEntry("Minute1",0);
	hour[1]=config->readNumEntry("Hour2",7);
	minute[1]=config->readNumEntry("Minute2",0);
	hour[2]=config->readNumEntry("Hour3",7);
	minute[2]=config->readNumEntry("Minute3",0);
	hour[3]=config->readNumEntry("Hour4",7);
	minute[3]=config->readNumEntry("Minute4",0);
	hour[4]=config->readNumEntry("Hour5",7);
	minute[4]=config->readNumEntry("Minute5",0);
	hour[5]=config->readNumEntry("Hour6",7);
	minute[5]=config->readNumEntry("Minute6",0);
	hour[6]=config->readNumEntry("Hour7",7);
	minute[6]=config->readNumEntry("Minute7",0);

	days[0]=config->readBoolEntry("Monday",false);
	days[1]=config->readBoolEntry("Tuesday",false);
	days[2]=config->readBoolEntry("Wednesday",false);
	days[3]=config->readBoolEntry("Thursday",false);
	days[4]=config->readBoolEntry("Friday",false);
	days[5]=config->readBoolEntry("Saturday",false);
	days[6]=config->readBoolEntry("Sunday",false);
	
	volEndVal=config->readNumEntry("VolumeEnd",80);
	modeAlarm=config->readNumEntry("ModeAlarm",0);
//	songlist=config->readEntry("List","");
}

void Wakeup::slotCheckTime()
{
	TQTime t;
	TQDate d;

	t=TQTime::currentTime();
	d=TQDate::currentDate();

	if (t.minute()!=minute[d.dayOfWeek()-1] || t.hour()!=hour[d.dayOfWeek()-1]) return;

	if (days[d.dayOfWeek()-1])
	{
		//napp->player()->play();
		PlayerAct();
	}
}

void Wakeup::PlayerAct()
{
    if (modeAlarm==1 && !napp->player()->isPlaying())
    {
	    napp->player()->setVolume(0);
    }
        
    if (!napp->player()->isPlaying() && modeAlarm!=2) napp->player()->play();
        
    // timer for volume (up/down) according to prefs :-)
    volTimer = new TQTimer (this);
    connect (volTimer,TQT_SIGNAL(timeout()), TQT_SLOT(slotVolumeChange()));
    
    volTimer->start(1000,false); // updates volume every seconds
        
}

void Wakeup::slotVolumeChange()
{
	int vol = napp->player()->volume();
	if ( vol >= volEndVal && modeAlarm==1)
	{
		volTimer->stop();
		return;
	}
	else if (vol <= 0 && modeAlarm==2)
	{
		volTimer->stop();
		napp->player()->stop();
		return;
	}
	else if (modeAlarm==0)
	{
		volTimer->stop();
		return;
	}
	
	if (modeAlarm==1)
	{
		napp->player()->setVolume( vol + 1 );
	}
	else if (modeAlarm==2)
	{
		napp->player()->setVolume( vol - 1 );
	}
}

///////////////////////////////////////////////////////////////////
// Prefs CModule 
///////////////////////////////////////////////////////////////////
WakeupPrefs::WakeupPrefs( TQObject *parent ) :
	CModule( i18n("Wakeup"), i18n("Alarm Configuration"), "date", parent )
{
	TQVBoxLayout *layout = new TQVBoxLayout(this, KDialog::marginHint(), KDialog::spacingHint());
	TQGridLayout *grid = new TQGridLayout (layout,8,4);
	
	monday=new TQCheckBox(i18n("Monday"),this);
	tuesday=new TQCheckBox(i18n("Tuesday"),this);
	wednesday=new TQCheckBox(i18n("Wednesday"),this);
	thursday=new TQCheckBox(i18n("Thursday"),this);
	friday=new TQCheckBox(i18n("Friday"),this);
	saturday=new TQCheckBox(i18n("Saturday"),this);
	sunday=new TQCheckBox(i18n("Sunday"),this);
	hour1 = new TQSpinBox(0, 23, 1, this , "Hour1");
	hour1->setButtonSymbols(TQSpinBox::PlusMinus);
	minute1 = new KMinuteSpinBox(1, this , "Minute1");
	hour2 = new TQSpinBox(0, 23, 1, this, "Hour2");
	hour2->setButtonSymbols(TQSpinBox::PlusMinus);
	minute2 = new KMinuteSpinBox(1, this, "Minute2");
	hour3 = new TQSpinBox(0, 23, 1, this, "Hour3");
	hour3->setButtonSymbols(TQSpinBox::PlusMinus);
	minute3 = new KMinuteSpinBox(1, this, "Minute3");
	hour4 = new TQSpinBox(0, 23, 1, this, "Hour4");
	hour4->setButtonSymbols(TQSpinBox::PlusMinus);
	minute4 = new KMinuteSpinBox(1, this, "Minute4");
	hour5 = new TQSpinBox(0, 23, 1, this, "Hour5");
	hour5->setButtonSymbols(TQSpinBox::PlusMinus);
	minute5 = new KMinuteSpinBox(1, this, "Minute5");
	hour6 = new TQSpinBox(0, 23, 1, this, "Hour6");
	hour6->setButtonSymbols(TQSpinBox::PlusMinus);
	minute6 = new KMinuteSpinBox(1, this, "Minute6");
	hour7 = new TQSpinBox(0, 23, 1, this, "Hour7");
	hour7->setButtonSymbols(TQSpinBox::PlusMinus);
	minute7 = new KMinuteSpinBox(1, this, "Minute7");
	
	TQLabel *selectday = new TQLabel (i18n("Select days:"),this);
	TQLabel *choosehour = new TQLabel (i18n("Hour"),this);
	TQLabel *choosemin = new TQLabel (i18n("Minute"),this);
	grid->addWidget (selectday,0,0,TQt::AlignLeft); 
	grid->addWidget (choosehour,0,1,TQt::AlignLeft); 
	grid->addWidget (choosemin,0,2,TQt::AlignLeft); 

	applyall = new TQPushButton (this,"applyall");
	applyall->setPixmap( BarIcon("go-down", TDEIcon::SizeSmall) ); 
	applyall->setSizePolicy( TQSizePolicy( TQSizePolicy::Fixed, 
						TQSizePolicy::Fixed, 
						applyall->sizePolicy().hasHeightForWidth()) );
	grid->addWidget (applyall,1,3,TQt::AlignLeft);						

	grid->addWidget (monday,1,0,TQt::AlignLeft);
	grid->addWidget (tuesday,2,0,TQt::AlignLeft);
	grid->addWidget (wednesday,3,0,TQt::AlignLeft);
	grid->addWidget (thursday,4,0,TQt::AlignLeft);
	grid->addWidget (friday,5,0,TQt::AlignLeft);
	grid->addWidget (saturday,6,0,TQt::AlignLeft);
	grid->addWidget (sunday,7,0,TQt::AlignLeft);
	grid->addWidget (hour1,1,1,TQt::AlignLeft);
	grid->addWidget (hour2,2,1,TQt::AlignLeft);
	grid->addWidget (hour3,3,1,TQt::AlignLeft);
	grid->addWidget (hour4,4,1,TQt::AlignLeft);
	grid->addWidget (hour5,5,1,TQt::AlignLeft);
	grid->addWidget (hour6,6,1,TQt::AlignLeft);
	grid->addWidget (hour7,7,1,TQt::AlignLeft);
	grid->addWidget (minute1,1,2,TQt::AlignLeft);
	grid->addWidget (minute2,2,2,TQt::AlignLeft);
	grid->addWidget (minute3,3,2,TQt::AlignLeft);
	grid->addWidget (minute4,4,2,TQt::AlignLeft);
	grid->addWidget (minute5,5,2,TQt::AlignLeft);
	grid->addWidget (minute6,6,2,TQt::AlignLeft);
	grid->addWidget (minute7,7,2,TQt::AlignLeft);
	grid->setColStretch (0,3);
	
	TQButtonGroup *modeGroup = new TQButtonGroup (3, Qt::Vertical, i18n ("Volume Control"),this);
	alarmmode = new TQRadioButton (i18n("No change to volume, just starts the player"),modeGroup);
	nightmode = new TQRadioButton (i18n("The volume decreases slowly and finally stops the player"),modeGroup);
	morningmode = new TQRadioButton (i18n("The player starts and the volume increases to the chosen value"),modeGroup);
	modeGroup->setExclusive(true);
	morningmode->setChecked(true);

	volFrame = new TQFrame (this);
	TQLabel *volEndLabel = new TQLabel (i18n("Volume increases to:"), volFrame);
	volEndValue = new KPercentSpinBox (1 ,volFrame,"volendvalue");

	layout->addWidget(modeGroup);
	layout->addWidget(volFrame);
	layout->addStretch();

	TQHBoxLayout *volLayout = new TQHBoxLayout(volFrame, KDialog::marginHint(), KDialog::spacingHint()); 
	volLayout->addWidget(volEndLabel);
	volLayout->addWidget(volEndValue);
	volLayout->addStretch();
	
	connect (morningmode,TQT_SIGNAL(stateChanged(int)),TQT_SLOT(slotViewFrame(int)));
	connect (applyall,TQT_SIGNAL(clicked()),TQT_SLOT(slotApplyAll()));
	
	load();
}

void WakeupPrefs::slotApplyAll()
{
	hour2->setValue(hour1->text().toInt());
	hour3->setValue(hour1->text().toInt());
	hour4->setValue(hour1->text().toInt());
	hour5->setValue(hour1->text().toInt());
	hour6->setValue(hour1->text().toInt());
	hour7->setValue(hour1->text().toInt());
	minute2->setValue(minute1->text().toInt());
	minute3->setValue(minute1->text().toInt());
	minute4->setValue(minute1->text().toInt());
	minute5->setValue(minute1->text().toInt());
	minute6->setValue(minute1->text().toInt());
	minute7->setValue(minute1->text().toInt());
}

void WakeupPrefs::slotViewFrame(int state)
{
	if (state==2) volFrame->show();
	else volFrame->hide();
}

void WakeupPrefs::save()
{
	TDEConfig *config=TDEGlobal::config();
	config->setGroup("Noatun Alarm");
	config->writeEntry("Monday",monday->isChecked());
	config->writeEntry("Tuesday",tuesday->isChecked());
	config->writeEntry("Wednesday",wednesday->isChecked());
	config->writeEntry("Thursday",thursday->isChecked());
	config->writeEntry("Friday",friday->isChecked());
	config->writeEntry("Saturday",saturday->isChecked());
	config->writeEntry("Sunday",sunday->isChecked());
	config->writeEntry("Hour1",hour1->text());
	config->writeEntry("Minute1",minute1->text());
	config->writeEntry("Hour2",hour2->text());
	config->writeEntry("Minute2",minute2->text());
	config->writeEntry("Hour3",hour3->text());
	config->writeEntry("Minute3",minute3->text());
	config->writeEntry("Hour4",hour4->text());
	config->writeEntry("Minute4",minute4->text());
	config->writeEntry("Hour5",hour5->text());
	config->writeEntry("Minute5",minute5->text());
	config->writeEntry("Hour6",hour6->text());
	config->writeEntry("Minute6",minute6->text());
	config->writeEntry("Hour7",hour7->text());
	config->writeEntry("Minute7",minute7->text());
	TQString val(volEndValue->text());
	config->writeEntry("VolumeEnd",val);
	
	if (nightmode->isChecked()) config->writeEntry("ModeAlarm",2);
	else if (morningmode->isChecked()) config->writeEntry("ModeAlarm",1);
	else config->writeEntry("ModeAlarm", 0);
		
	config->sync();

	Wakeup *wake = Wakeup::wakeme;
	if (wake) wake->update();
}

void WakeupPrefs::load()
{
	TDEGlobal::config()->setGroup("Noatun Alarm");
	monday->setChecked(TDEGlobal::config()->readBoolEntry("Monday",false));
	tuesday->setChecked(TDEGlobal::config()->readBoolEntry("Tuesday",false));
	wednesday->setChecked(TDEGlobal::config()->readBoolEntry("Wednesday",false));
	thursday->setChecked(TDEGlobal::config()->readBoolEntry("Thursday",false));
	friday->setChecked(TDEGlobal::config()->readBoolEntry("Friday",false));
	saturday->setChecked(TDEGlobal::config()->readBoolEntry("Saturday",false));
	sunday->setChecked(TDEGlobal::config()->readBoolEntry("Sunday",false));

	hour1->setValue(TDEGlobal::config()->readNumEntry("Hour1",7));
	minute1->setValue(TDEGlobal::config()->readNumEntry("Minute1",0));
	hour2->setValue(TDEGlobal::config()->readNumEntry("Hour2",7));
	minute2->setValue(TDEGlobal::config()->readNumEntry("Minute2",0));
	hour3->setValue(TDEGlobal::config()->readNumEntry("Hour3",7));
	minute3->setValue(TDEGlobal::config()->readNumEntry("Minute3",0));
	hour4->setValue(TDEGlobal::config()->readNumEntry("Hour4",7));
	minute4->setValue(TDEGlobal::config()->readNumEntry("Minute4",0));
	hour5->setValue(TDEGlobal::config()->readNumEntry("Hour5",7));
	minute5->setValue(TDEGlobal::config()->readNumEntry("Minute5",0));
	hour6->setValue(TDEGlobal::config()->readNumEntry("Hour6",7));
	minute6->setValue(TDEGlobal::config()->readNumEntry("Minute6",0));
	hour7->setValue(TDEGlobal::config()->readNumEntry("Hour7",7));
	minute7->setValue(TDEGlobal::config()->readNumEntry("Minute7",0));
	
	TQString volend(TDEGlobal::config()->readEntry("VolumeEnd","80%"));
	volend.truncate(volend.length()-1);
	
	volEndValue->setValue(volend.toInt());
	
	switch (TDEGlobal::config()->readNumEntry("ModeAlarm",0))
	{
		case 0:
			alarmmode->setChecked(true);
			break;
		case 1:
			morningmode->setChecked(true);
			break;
		case 2:
			nightmode->setChecked(true);
			break;
		default:
			alarmmode->setChecked(true);
	}
}

#include "wakeup.moc"
