/***************************************************************************
    Copyright: nspanel.cpp
    Marcus Camen  <mcamen@mcamen.de>
***************************************************************************/

/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#include <tqlistview.h>
#include <tqfontmetrics.h>
#include <tqtimer.h>
#include <kdebug.h>
#include <tdelistbox.h>
#include "nspanel.h"


namespace KSB_News {

////////////////////////////////////////////////////////////////
// ListBox including ToolTip for item
////////////////////////////////////////////////////////////////
  TTListBox::TTListBox(TQWidget *parent, const char *name, WFlags f)
    : TDEListBox(parent, name, f),
      TQToolTip(this) {
  }

  void TTListBox::clear() {
    TDEListBox::clear();
  }

  void TTListBox::maybeTip(const TQPoint &point) {
    TQListBoxItem *item = itemAt(point);
    if (item) {
      TQString text = item->text();
      if (!text.isEmpty()) {
        // Show ToolTip only if necessary
        TQFontMetrics fm(fontMetrics());
        int textWidth = fm.width(text);
        int widgetSpace = visibleWidth();
        if ((textWidth > widgetSpace) || (contentsX() > 0))
          tip(itemRect(item), text);
      }
    }
  }



  NSPanel::NSPanel(TQObject *parent, const char *name, const TQString &key,
                   DCOPRef *rssservice)
    :TQObject(parent, name)
    ,DCOPObject(TQString(TQString("sidebar-newsticker-")+key).latin1())
    ,m_listbox()
    ,m_pixmap()
{
    kdDebug(90140) << "NSPanel: CTOR " << key << " " << rssservice << endl;

    m_rssservice = rssservice;
    m_key = key;
    m_rssdocument = m_rssservice->call("document(TQString)", m_key);
    m_isValid = false;

    connectDCOPSignal("rssservice", m_rssdocument.obj(),
                      "documentUpdated(DCOPRef)",
                      "emitDocumentUpdated(DCOPRef)", false);
    connectDCOPSignal("rssservice", m_rssdocument.obj(),
                      "documentUpdated(DCOPRef)",
                      "emitTitleUpdated(DCOPRef)", false);
    connectDCOPSignal("rssservice", m_rssdocument.obj(),
                      "pixmapUpdated(DCOPRef)",
                      "emitPixmapUpdated(DCOPRef)", false);

    // updating of RSS documents
    m_timeoutinterval = 10 * 60 * 1000;   // 10 mins
    m_timer = new TQTimer(this);
    connect(m_timer, TQT_SIGNAL(timeout()), this, TQT_SLOT(refresh()));
    m_timer->start(m_timeoutinterval);
    refresh();
  }


  void NSPanel::refresh() {
    m_rssdocument.call("refresh()");
  }


  NSPanel::~NSPanel() {
  }


  void NSPanel::setTitle(const TQString &tit) {
    m_title = tit;
  }


  void NSPanel::setListbox(TTListBox *lb) {
    m_listbox = lb;
  }


  void NSPanel::setPixmap(const TQPixmap &pm) {
    m_pixmap = pm;
  }


  TTListBox *NSPanel::listbox() const {
    return m_listbox;
  }


  TQPixmap NSPanel::pixmap() {
    return m_pixmap;
  }


  TQString NSPanel::key() const {
    return m_key;
  }

  TQString NSPanel::title() const {
    return m_title;
  }

  TQStringList NSPanel::articles() {
    return m_articles;
  }

  TQStringList NSPanel::articleLinks() {
    return m_articlelinks;
  }

  bool NSPanel::isValid() const {
    return m_isValid;
  }


  void NSPanel::emitDocumentUpdated(DCOPRef /*dcopref*/) {
    kdDebug(90140) << "NSPanel::emitDocumentUpdated" << endl;

    m_articles.clear();
    m_articlelinks.clear();
    m_count = m_rssdocument.call("count()");
    TQString temp = m_rssdocument.call("title()");
    m_title = temp;
    m_isValid = true;
    for (int idx = 0; idx < m_count; ++idx) {
      DCOPRef rss_article = m_rssdocument.call("article(int)", idx);
      m_articles.append(rss_article.call("title()"));
      m_articlelinks.append(rss_article.call("link()"));
    }

    emit documentUpdated(this);
  }

  void NSPanel::emitPixmapUpdated(DCOPRef /*dcopref*/) {
    if (m_rssdocument.call("pixmapValid()")) {
      TQPixmap tmp = m_rssdocument.call("pixmap()");
      m_pixmap = tmp;

      emit pixmapUpdated(this);
    }
  }

} // namespace KSB_News

#include "nspanel.moc"
