/***************************************************************************
 *   Copyright (C) 2005 by Florian Roth   *
 *   florian@synatic.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 
#include "metabarwidget.h"
#include "settingsplugin.h"

#include <tdecmoduleinfo.h>
#include <kservice.h>
#include <tdelocale.h>

#include <html_document.h>
#include <html_element.h>
#include <dom_string.h>

SettingsPlugin::SettingsPlugin(TDEHTMLPart* html, MetabarFunctions *functions, const char *name) : ProtocolPlugin (html, functions, name)
{
  list_job = 0;
}

SettingsPlugin::~SettingsPlugin()
{
}

void SettingsPlugin::killJobs()
{  
  if(list_job){
    list_job->kill();
    list_job = 0;
  }
}

void SettingsPlugin::deactivate()
{   
  m_functions->hide("actions");
  m_functions->hide("info");
}

void SettingsPlugin::loadActions(DOM::HTMLElement node)
{
  KURL url = m_items.getFirst()->url();
  
  if(url.path().endsWith("/")){
    list_job = TDEIO::listDir(url, true, false);
    connect(list_job, TQT_SIGNAL(entries(TDEIO::Job *, const TDEIO::UDSEntryList &)), this, TQT_SLOT(slotGotEntries(TDEIO::Job *, const TDEIO::UDSEntryList &)));
    connect(list_job, TQT_SIGNAL(result(TDEIO::Job *)), this, TQT_SLOT(slotJobFinished(TDEIO::Job *)));
  
    m_functions->show("actions");
  }
  else{
    TQString path = url.path();
    TQString name = url.filename();
    
    KService::Ptr service = KService::serviceByStorageId(name);
    if(service && service->isValid()){
      TDECModuleInfo kcminfo(service);
      
      DOM::DOMString innerHTML;      
      MetabarWidget::addEntry(innerHTML, i18n("Run"), "tdecmshell:/" + name, kcminfo.icon());
      node.setInnerHTML(innerHTML);
      
      m_functions->show("actions");
    }
    else{
      m_functions->hide("actions");
    }
  }
}

void SettingsPlugin::loadInformation(DOM::HTMLElement node)
{
  KURL url = m_items.getFirst()->url();
  if(url.path().endsWith("/")){
    m_functions->hide("info");
  }
  else{
    TQString path = url.path();
    TQString name = url.filename();
    
    KService::Ptr service = KService::serviceByStorageId(name);
    if(service && service->isValid()){
      TDECModuleInfo kcminfo(service);
      
      bool needsRoot = kcminfo.needsRootPrivileges();
    
      DOM::DOMString innerHTML;
      innerHTML += "<ul class=\"info\"><b>" + i18n("Name") + ": </b>";
      innerHTML += kcminfo.moduleName();
      innerHTML += "</ul><ul class=\"info\"><b>" + i18n("Comment") + ": </b>";
      innerHTML += kcminfo.comment();
      innerHTML += "</ul>";
      
      if(needsRoot){
        innerHTML += "<ul class=\"info\"><b>";
        innerHTML += i18n("Needs root privileges");
        innerHTML += "</b></ul>";
      }
      node.setInnerHTML(innerHTML);
      
      m_functions->show("info");
    }
    else{
      m_functions->hide("info");
    }
  }
}

void SettingsPlugin::loadApplications(DOM::HTMLElement node)
{
  m_functions->hide("open");
}

void SettingsPlugin::loadPreview(DOM::HTMLElement node)
{
  m_functions->hide("preview");
}

void SettingsPlugin::loadBookmarks(DOM::HTMLElement node)
{
  m_functions->hide("bookmarks");
}

bool SettingsPlugin::handleRequest(const KURL &)
{  
  return false;
}

void SettingsPlugin::slotGotEntries(TDEIO::Job *job, const TDEIO::UDSEntryList &list)
{
  if(!job){
    return;
  }
  
  DOM::HTMLDocument doc = m_html->htmlDocument();
  DOM::HTMLElement node = doc.getElementById("actions");
  DOM::DOMString innerHTML;
  
  TDEIO::UDSEntryList::ConstIterator it     = list.begin();
  TDEIO::UDSEntryList::ConstIterator it_end = list.end();
  for(; it != it_end; ++it){
    TQString name;
    TQString icon;
    TQString url;
    long type;
  
    TDEIO::UDSEntry::ConstIterator atomit     = (*it).begin();
    TDEIO::UDSEntry::ConstIterator atomit_end = (*it).end();
    for(; atomit != atomit_end; ++atomit){
      if((*atomit).m_uds == TDEIO::UDS_NAME){
        name = (*atomit).m_str;
      }
      else if((*atomit).m_uds == TDEIO::UDS_ICON_NAME){
        icon = (*atomit).m_str;
      }
      else if((*atomit).m_uds == TDEIO::UDS_URL){
        url = (*atomit).m_str;
      }
      
      else if((*atomit).m_uds == TDEIO::UDS_FILE_TYPE){
        type = (*atomit).m_long;
      }
    }
    
    kdDebug() << url << endl;
    
    if(type == S_IFREG){
      url = "tdecmshell:/" + KURL(url).filename();
    }

    MetabarWidget::addEntry(innerHTML, name, url, icon);
  }
  
  node.setInnerHTML(innerHTML);
}

void SettingsPlugin::slotJobFinished(TDEIO::Job *job)
{
  if(list_job && job == list_job){
    list_job = 0;

    m_functions->adjustSize("actions");
  }
}

#include "settingsplugin.moc"
