/***************************************************************************
                          mediawidget.cpp - The main widget
                             -------------------
    begin                : Sat June 23 13:35:30 CEST 2001
    copyright            : (C) 2001 Joseph Wenninger
    email                : jowenn@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mediawidget.h"
#include "mediawidget.moc"
#include "player.h"

#include <kdebug.h>
#include <kurl.h>
#include <kurldrag.h>
#include <tdelocale.h>

#include <tqlabel.h>
#include <tqwidget.h>
#include <tqpushbutton.h>
#include <tqlcdnumber.h>
#include <tqpopupmenu.h>
#include <tqslider.h>
#include <tqtooltip.h>

KSB_MediaWidget::KSB_MediaWidget(TQWidget *parent):KSB_MediaWidget_skel(parent)
{
	player = new Player(TQT_TQOBJECT(this));
	empty();

	TQFont labelFont = time->font();
	labelFont.setPointSize(18);
	labelFont.setBold(true);
	time->setFont(labelFont);

	connect(Play, TQT_SIGNAL(clicked()), player, TQT_SLOT(play()));
	connect(Pause, TQT_SIGNAL(clicked()), player, TQT_SLOT(pause()));
	connect(Stop, TQT_SIGNAL(clicked()), player, TQT_SLOT(stop()));

	connect(player, TQT_SIGNAL(timeout()), this, TQT_SLOT(playerTimeout()));
	connect(player, TQT_SIGNAL(finished()), this, TQT_SLOT(playerFinished()));
	connect(player, TQT_SIGNAL(playing()), this, TQT_SLOT(playing()));
	connect(player, TQT_SIGNAL(paused()), this, TQT_SLOT(paused()));
	connect(player, TQT_SIGNAL(stopped()), this, TQT_SLOT(stopped()));
	connect(player, TQT_SIGNAL(empty()), this, TQT_SLOT(empty()));

	connect(Position, TQT_SIGNAL(userChanged(int)), this, TQT_SLOT(skipToWrapper(int)));
	connect(this, TQT_SIGNAL(skipTo(unsigned long)), player, TQT_SLOT(skipTo(unsigned long)));
	setAcceptDrops(true);

	pretty="";
	needLengthUpdate=false;

	TQToolTip::add(Play,i18n("Play"));
	TQToolTip::add(Pause,i18n("Pause"));
	TQToolTip::add(Stop,i18n("Stop"));
}

void KSB_MediaWidget::skipToWrapper(int second)
{
	emit skipTo((unsigned long)(second*1000));
}

void KSB_MediaWidget::dragEnterEvent ( TQDragEnterEvent * e)
{
	e->accept(KURLDrag::canDecode(e));
}

void KSB_MediaWidget::dropEvent ( TQDropEvent * e)
{
	m_kuri_list.clear();
	if (KURLDrag::decode(e, m_kuri_list))
	{
		playerFinished();
	}
}


void KSB_MediaWidget::playerTimeout()
{
	if(player->current().isEmpty())
		return;

	if(Position->currentlyPressed())
		return;

// update the scrollbar length
	if(player->getLength())
	{
		int range = (int)(player->getLength() / 1000);
		Position->setRange(0, range);
		if (needLengthUpdate)
		{
			int counter = player->lengthString().length() - (player->lengthString().find("/")+1);
			TQString length=player->lengthString().right(counter);
			needLengthUpdate=false;
		}
	}
	else
	{
		Position->setRange(0, 1);
	}
	// set the position
	Position->setValue((int)(player->getTime() / 1000));

	// update the time label
	// catch files with duration > 99mins correctly
	time->setText(player->lengthString());
}

void KSB_MediaWidget::playerFinished()
{
	if( m_kuri_list.count() > 0 )
	{
		KURL kurl = m_kuri_list.first();
		m_kuri_list.remove( kurl );
		bool validFile = player->openFile( kurl );
		if (validFile) {
			currentFile->setText( kurl.fileName() );
			player->play();
			needLengthUpdate=true;
			pretty=kurl.prettyURL();
		} else {
			currentFile->setText( i18n("Not a sound file") );
			playerFinished();
		}
	}
}

void KSB_MediaWidget::playing()
{
	Play->setEnabled(false);
	Pause->setEnabled(true);
	Stop->setEnabled(true);
}

void KSB_MediaWidget::paused()
{
	Play->setEnabled(true);
	Pause->setEnabled(false);
	Stop->setEnabled(true);
}

void KSB_MediaWidget::stopped()
{
	Position->setValue(0);
	time->setText("00:00/00:00");
	Play->setEnabled(true);
	Pause->setEnabled(false);
	Stop->setEnabled(false);
}

void KSB_MediaWidget::empty()
{
	Position->setValue(0);
	time->setText("00:00/00:00");
	Play->setEnabled(false);
	Pause->setEnabled(false);
	Stop->setEnabled(false);
}
