#ifndef REGIONWIDGET_H
#define REGIONWIDGET_H

#include <tqframe.h>

/**
 * show a widget with a field rectangle, and a mini-region inside
 * 
 * text boxes allow the region to be resized and moved, along with
 * click-n-drag
 **/
class RegionWidget : public TQFrame
{
Q_OBJECT
  
public:
	RegionWidget(TQWidget *parent);
	RegionWidget(const TQSize &viewsize, TQWidget *parent);
	RegionWidget(int x, int y, int w, int h, const TQSize &viewsize, 
	             TQWidget *parent);
	RegionWidget(const TQRect &region, const TQSize &viewsize, TQWidget *parent);
	
	~RegionWidget();
	
	TQRect region() const;
	
public slots:
	void setX(int x);
	void setY(int y);
	void setWidth(int w);
	void setHeight(int h);
	
	void setRegion(const TQRect &region);
	
	void setViewSize(const TQSize &size);

signals:
	void changed();
	void changed(int x, int y, int w, int h);
	void changed(const TQRect &region);

protected:
	virtual void moved(int x, int y);
	virtual void resized(int w, int h);
};


#endif
