#include <tdelocale.h>
#include <tqheader.h>
#include <tqlayout.h>
#include <tqdragobject.h>
#include <tdefiledialog.h>
#include <kstdaction.h>
#include <tdeaction.h>

#include "gui.h"
#include "renderers.h"
#include "nex.h"

class CreatorItem : public TQListViewItem
{
public:
	CreatorItem(TQListView *parent, const TQString &title)
		: TQListViewItem(parent, title)
		{}
};

class TreeItem : public TQListViewItem
{
public:
	TreeItem(TreeItem *parent, TreeItem *after, CreatorItem *creator)
		: TQListViewItem(parent, after, creator->text(0))
	{
		RendererList *list;
		if (parent)
			list=static_cast<RendererList*>(parent->mRenderer);
		else
			list=nex->rendererList();
		
		Renderer *afterRenderer=0;
		if (after)
			afterRenderer=after->mRenderer;
		
		list->lock();
		int pos=list->renderers().findRef(afterRenderer);
		if (pos==-1) pos=list->renderers().count();
		
		list->renderers().insert((uint)pos, mRenderer=nex->renderer(creator->text(0)));
		list->unlock();
	}
	
	TreeItem(TQListView *parent, TreeItem *after, const TQString &title)
		: TQListViewItem(parent, after, title)
	{
		mRenderer=nex->rendererList();
		setExpandable(true);
	}
	
	~TreeItem()
	{
		RendererList *list;
		if (parent())
			list=static_cast<RendererList*>(static_cast<TreeItem*>(parent())->mRenderer);
		else
			return;
		
		list->lock();
		list->renderers().removeRef(mRenderer);
		list->unlock();
		delete mRenderer;
	}

	Renderer *renderer() { return mRenderer; }
private:
	Renderer *mRenderer;
};

Control::Control() : mConfigurator(0)
{
	{
		TDEToolBar *tools=toolBar();
		KStdAction::save(this, TQT_SLOT(save()), actionCollection())->plug(tools);
		KStdAction::saveAs(this, TQT_SLOT(saveAs()), actionCollection())->plug(tools);
		KStdAction::open(this, TQT_SLOT(open()), actionCollection())->plug(tools);
	
	}
	
	setCaption(i18n("Nex Configuration"));
	TQSplitter *mainSplitter=new TQSplitter(this);
	setCentralWidget(mainSplitter);
	TQSplitter *left=new TQSplitter(Qt::Vertical, mainSplitter);
	{
		mTree=new RendererListView(left);
		mTree->setItemsMovable(true);
		mTree->setSorting(-1);
		mTree->setRootIsDecorated(true);
		
		connect(mTree, TQT_SIGNAL(dropped(TQDropEvent*, TQListViewItem*, TQListViewItem*)),
		        TQT_SLOT(dropEvent(TQDropEvent*, TQListViewItem*, TQListViewItem*)));
		
		connect(mTree, TQT_SIGNAL(currentChanged(TQListViewItem*)),
		        TQT_SLOT(currentChanged(TQListViewItem*)));
		
		mCreatorsList=new RendererListView(left);
		mCreatorsList->addColumn(i18n("Name"));
		mCreatorsList->header()->hide();
		mCreatorsList->setDropVisualizer(false);
	}
		
	mRight=new TQWidget(mainSplitter);
	(new TQHBoxLayout(mRight))->setAutoAdd(true);
	
	TQStringList list=nex->renderers();
	for (TQStringList::Iterator i=list.begin(); i!=list.end(); ++i)
		addCreator(*i);
		
	new TreeItem(mTree, 0, i18n("Main"));
}

void Control::save(const KURL &file)
{
// TODO
}

void Control::save()
{
	if (mCurrentURL.isEmpty())
		saveAs();
	else
		save(mCurrentURL);
}

void Control::saveAs()
{
	KURL url;
	url=KFileDialog::getSaveURL(0, "application/x-nexscope", this);
	if (!url.isEmpty())
		save(mCurrentURL=url);
}

void Control::open()
{
	KURL url=KFileDialog::getOpenURL(0, "application/x-nexscope");
	if (!url.isEmpty())
		open(mCurrentURL=url);
}

void Control::open(const KURL &file)
{
// TODO
}


void Control::addCreator(const TQString &title)
{
	new CreatorItem(mCreatorsList, title);
}

void Control::dropEvent(TQDropEvent *e, TQListViewItem *parent, TQListViewItem *pafter)
{
//	if ((e->source() == mCreatorsList) && parent)
	{
		CreatorItem *i=static_cast<CreatorItem*>(mCreatorsList->currentItem());
		if (!i)
		{
			std::cerr << "no creatoritem" << std::endl;

		}
		new TreeItem(static_cast<TreeItem*>(parent), static_cast<TreeItem*>(pafter), i);
	}
}

void Control::currentChanged(TQListViewItem *item)
{
	TreeItem *treeItem=static_cast<TreeItem*>(item);
	delete mConfigurator;
	mConfigurator=treeItem->renderer()->configure(mRight);
	if (mConfigurator)
		mConfigurator->show();
}


RendererListView::RendererListView(TQWidget *p) : TDEListView(p)
{
	addColumn(i18n("Name"));
	header()->hide();
	setDragEnabled(true);
	setAcceptDrops(true);
	setSelectionMode(TQListView::Single);
}
	
bool RendererListView::acceptDrag(TQDropEvent *event) const
{
	return true; //TQCString(event->format()) == "application/x-nex-rendererdrag";
}

TQDragObject *RendererListView::dragObject() const
{
	if (!currentItem()) return 0;
	return new TQStoredDrag("application/x-nex-rendererdrag", (TQWidget*)this);
}


#include "gui.moc"
