#ifndef LYRICS_H
#define LYRICS_H

#include <noatun/plugin.h>
#include <noatun/player.h>
#include <noatun/app.h>
#include <tdemainwindow.h>
#include <tqvaluevector.h>
#include <tdehtml_part.h>
#include <tdeaction.h>
#include "cmodule.h"

class HistoryManager;

class Lyrics : public TDEMainWindow, public Plugin {
Q_OBJECT
  

public:
  Lyrics();
  ~Lyrics();
  void go(const KURL &);
  void setProviders( TQValueVector<SearchProvider> &sites );

public slots:
  void viewLyrics(int index = -1);
  void back();
  void forward();

protected:
	bool queryClose();

protected slots:
  void changeUI(int, bool);
  void openURLRequest( const KURL &, const KParts::URLArgs & );
  void loadingURL(TDEIO::Job *);
  void loadedURL();
  void attach(bool);
  void newSong();
  void goTo();

private:
	int menuID;
  TDEAction *back_act, *forward_act;
  TDEToggleAction *follow_act;
  TDEToggleAction *attach_act;
  TDESelectAction *site_act;
	TDEHTMLPart *htmlpart;
  TQValueVector<SearchProvider> mSites;
  HistoryManager *history;
  bool active;

};


#endif
