/****************************************************************************
 *   Copyright (C) 2001 by Hugo Varotto										*
 *   hugo@varotto-usa.com													*
 *																			*
 *	 Based on Kate's fileselector widget	by									*
 *          Matt Newell														*
 *			(C) 2001 by Matt Newell											*
 *			newellm@proaxis.com												*
 *																			*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by		*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version										*
 *																			*
 ***************************************************************************/

#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqstrlist.h>
#include <tqtooltip.h>

#include <kiconloader.h>
#include <kurlcombobox.h>
#include <kurlcompletion.h>
#include <kprotocolinfo.h>
#include <tdediroperator.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <kcombobox.h>

#include <kdebug.h>

//#include "fileselector_part.h"
#include "fileselectorwidget.h"


FileSelectorWidget::FileSelectorWidget(TQWidget *parent)
    : TQWidget(parent, "file selector widget")
{

	// widgets and layout

	TQVBoxLayout* lo = new TQVBoxLayout(this);

	TQHBox *hlow = new TQHBox (this);
	lo->addWidget(hlow);

	home = new TQPushButton( hlow );
	home->setPixmap(SmallIcon("go-home"));
	TQToolTip::add(home, i18n("Home folder"));
	up = new TQPushButton( /*i18n("&Up"),*/ hlow );
	up->setPixmap(SmallIcon("go-up"));
	TQToolTip::add(up, i18n("Up one level"));
	back = new TQPushButton( /*i18n("&Back"),*/ hlow );
	back->setPixmap(SmallIcon("back"));
	TQToolTip::add(back, i18n("Previous folder"));
	forward = new TQPushButton( /*i18n("&Next"),*/ hlow );
	forward->setPixmap(SmallIcon("forward"));
	TQToolTip::add(forward, i18n("Next folder"));

	// HACK
	TQWidget* spacer = new TQWidget(hlow);
	hlow->setStretchFactor(spacer, 1);
	hlow->setMaximumHeight(up->height());

	cmbPath = new KURLComboBox( KURLComboBox::Directories, true, this, "path combo" );
	cmbPath->setSizePolicy( TQSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Fixed ));
	KURLCompletion* cmpl = new KURLCompletion();
	cmbPath->setCompletionObject( cmpl );
	lo->addWidget(cmbPath);

	dir = new KDirOperator(TQString(), this, "operator");
	dir->setView(KFile::Detail);
	lo->addWidget(dir);
	lo->setStretchFactor(dir, 2);

	TQHBox* filterBox = new TQHBox(this);
	filterIcon = new TQLabel(filterBox);
	filterIcon->setPixmap( BarIcon("filter") );
	filter = new KHistoryCombo(filterBox, "filter");
	filter->setSizePolicy( TQSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Fixed ));
	filterBox->setStretchFactor(filter, 2);
	lo->addWidget(filterBox);

	// slots and signals

	connect( filter, TQT_SIGNAL( activated(const TQString&) ), TQT_SLOT( slotFilterChange(const TQString&) ) );
	connect( filter, TQT_SIGNAL( returnPressed(const TQString&) ),filter, TQT_SLOT( addToHistory(const TQString&) ) );

	connect( home, TQT_SIGNAL( clicked() ), dir, TQT_SLOT( home() ) );
	connect( up, TQT_SIGNAL( clicked() ), dir, TQT_SLOT( cdUp() ) );
	connect( back, TQT_SIGNAL( clicked() ), dir, TQT_SLOT( back() ) );
	connect( forward, TQT_SIGNAL( clicked() ), dir, TQT_SLOT( forward() ) );

	connect( cmbPath, TQT_SIGNAL( urlActivated( const KURL&  )),
				this,  TQT_SLOT( cmbPathActivated( const KURL& ) ));
	connect( cmbPath, TQT_SIGNAL( returnPressed( const TQString&  )),
				this,  TQT_SLOT( cmbPathReturnPressed( const TQString& ) ));
	connect(dir, TQT_SIGNAL(urlEntered(const KURL&)),
				this, TQT_SLOT(dirUrlEntered(const KURL&)) );

	connect(dir, TQT_SIGNAL(finishedLoading()),
				this, TQT_SLOT(dirFinishedLoading()) );


    connect(dir, TQT_SIGNAL(fileHighlighted(const KFileItem *)),
                TQT_SLOT(fileHighlighted(const KFileItem *)));
    connect(dir, TQT_SIGNAL(fileSelected(const KFileItem *)),
                TQT_SLOT(fileSelected(const KFileItem *)));

    kdDebug(90010) << "connected stuff!" << endl;
}


FileSelectorWidget::~FileSelectorWidget()
{}

KURL FileSelectorWidget::currentDirectory()
{
  return dirLister()->url();
}

void FileSelectorWidget::slotFilterChange( const TQString & nf )
{
  dir->setNameFilter( nf );
  dir->rereadDir();
}

void FileSelectorWidget::cmbPathActivated( const KURL& u )
{
   dir->setURL( u, true );
}

void FileSelectorWidget::cmbPathReturnPressed( const TQString& u )
{
   dir->setFocus();
   dir->setURL( KURL(u), true );
}


void FileSelectorWidget::dirUrlEntered( const KURL& u )
{
   cmbPath->removeURL( u );
   TQStringList urls = cmbPath->urls();
   urls.prepend( u.url() );
   while ( urls.count() >= (uint)cmbPath->maxItems() )
      urls.remove( urls.last() );
   cmbPath->setURLs( urls );
}


void FileSelectorWidget::dirFinishedLoading()
{
   // HACK - enable the nav buttons
   // have to wait for diroperator...
   up->setEnabled( dir->actionCollection()->action( "up" )->isEnabled() );
   back->setEnabled( dir->actionCollection()->action( "back" )->isEnabled() );
   forward->setEnabled( dir->actionCollection()->action( "forward" )->isEnabled() );
   home->setEnabled( dir->actionCollection()->action( "home" )->isEnabled() );
}


void FileSelectorWidget::focusInEvent(TQFocusEvent*)
{
   dir->setFocus();
}

void FileSelectorWidget::setDir( KURL u )
{
  dir->setURL(u, true);
}

void FileSelectorWidget::fileHighlighted(const KFileItem *) {
  kdDebug(90010) << "file highlighted!" << endl;
}

void FileSelectorWidget::fileSelected(const KFileItem * ) {
  kdDebug(90010) << "file selected!" << endl;
}
#include "fileselectorwidget.moc"

