/*
    Copyright (c) 2003 Alexander Kellett <lypanov@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License (LGPL) as published by the Free Software Foundation;
    either version 2 of the License, or (at your option) any later
    version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __MINITOOLS_PLUGIN_H
#define __MINITOOLS_PLUGIN_H

#include <tqmap.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>

#include <kurl.h>
#include <klibloader.h>
#include <tdeparts/plugin.h>

class TDEHTMLPart;
class TDEActionMenu;

class MinitoolsPlugin : public KParts::Plugin {
   Q_OBJECT
  

public:
   MinitoolsPlugin( TQObject* parent, const char* name, const TQStringList & );
   ~MinitoolsPlugin();

protected slots:
   void slotAboutToShow();
   void slotEditBookmarks();
   void slotItemSelected(int);
   void newBookmarkCallback( const TQString &, const TQCString &, const TQString & );
   void endFolderCallback( );

signals:
   void executeScript( const TQString &script );

private:
   TQString minitoolsFilename(bool local);

   int m_selectedItem;
  
   TDEHTMLPart* m_part;
   TDEActionMenu* m_pMinitoolsMenu;
  
   typedef TQPair<TQString,TQCString> Minitool;
   typedef TQValueList<Minitool> MinitoolsList;
  
   MinitoolsList m_minitoolsList;
};

#endif
