/**********************************************************************/
/*   TimeMon (c)  1994  Helmut Maierhofer			                  */
/*   KDE-ified M. Maierhofer 1998                                     */
/*                                                                    */
/*   Ported to KDE 2.0 and other stuff:                               */
/*     Copyright (c) Dirk A. Mueller <dmuell@gmx.net>                 */
/*                                                                    */
/**********************************************************************/

/*
 * confdlg.h
 *
 * Definitions for the timemon configuration dialog.
 */

#ifndef CONFDLG_H
#define CONFDLG_H

#include <tqcolor.h>
#include <tqcheckbox.h>
#include <tqtabdialog.h>

#include <kcolorbutton.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <knuminput.h>
#include <kdialogbase.h>
#include <kurlrequester.h>

#include "timemon.h"

// -- forward declaration ------------------------------------------------

class KTimeMon;
class TQLineEdit;
class TQSlider;
class KColorButton;

// -- KConfDialog declaration --------------------------------------------

/*
 * KConfDialog
 */

class KConfDialog : public KDialogBase
{

    Q_OBJECT
  

public:
    KConfDialog(KTimeMon *timemon);
    ~KConfDialog() {}

    void update();		// get values from timemon

  unsigned getInterval() const { return intervalEdit->value(); }
  TQColor getKernelColour() const { return kernelCB->color(); }
  TQColor getUserColour() const { return userCB->color(); }
  TQColor getNiceColour() const { return niceCB->color(); }
  TQColor getIOWaitColour() const { return iowaitCB->color(); }
  TQColor getCachedColour() const { return cachedCB->color(); }
  TQColor getUsedColour() const { return usedCB->color(); }
  TQColor getBuffersColour() const { return buffersCB->color(); }
  TQColor getMKernelColour() const { return mkernelCB->color(); }
  TQColor getSwapColour() const { return swapCB->color(); }
  TQColor getBgColour() const { return bgCB->color(); }

  bool getAutoScale() const { return autoScaleBox->isChecked(); }
  unsigned getPageScale() const { return pageScaleEdit->value(); }
  unsigned getSwapScale() const { return swapScaleEdit->value(); }
  unsigned getCtxScale() const { return ctxScaleEdit->value(); }

  unsigned getMouseAction(int i) const;
  TQString getMouseActionCommand(int i) const { return mouseLE[i]->lineEdit()->text(); }

private slots:
  void updateSampleWidget(const TQColor &); // update colours in configuration
  void toggle(bool state);	// enable/disable scales
  void mouseCommandEnable();

private:

  KTimeMon *timemon;
  KIntNumInput *intervalEdit, *swapScaleEdit, *pageScaleEdit, *ctxScaleEdit;
  TQLineEdit *procFileEdit;
  TQCheckBox *autoScaleBox;
  KColorButton *kernelCB, *userCB, *niceCB, *iowaitCB;
  KColorButton *buffersCB, *usedCB, *cachedCB, *mkernelCB;
  KColorButton *swapCB, *bgCB;
  KURLRequester *mouseLE[MAX_MOUSE_ACTIONS];
  KComboBox *mouseC[MAX_MOUSE_ACTIONS];
  bool haveWarned;

  friend class KTimeMon;
};

#endif // CONFDLG_H
