/***************************************************************************
 *   Copyright (C) 2007 by Marián Kyral   *
 *   mkyral@email.cz   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _PLUGIN_SORT_H_
#define _PLUGIN_SORT_H_

#include <kate/application.h>
#include <kate/documentmanager.h>
#include <kate/document.h>
#include <kate/mainwindow.h>
#include <kate/plugin.h>
#include <kate/view.h>
#include <kate/viewmanager.h>

#include <klibloader.h>
#include <tdelocale.h>
#include <map>

#include "sortdialog.h"

class KatePluginFactory : public KLibFactory
{
  Q_OBJECT

  public:
    KatePluginFactory();
    virtual ~KatePluginFactory();

    virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0, const char* name = "TQObject", const TQStringList &args = TQStringList() );

  private:
    static TDEInstance* s_instance;
};

class KatePluginSort : public Kate::Plugin, Kate::PluginViewInterface
{
  Q_OBJECT

  public:
    KatePluginSort( TQObject* parent = 0, const char* name = 0 );
    virtual ~KatePluginSort();

    void addView (Kate::MainWindow *win);
    void removeView (Kate::MainWindow *win);

  public slots:
    void slotSort();

  private:
    TQPtrList<class PluginView> m_views;
    typedef std::multimap<TQString,TQString> TQStringMultiMap;
    typedef std::multimap<long,TQString> LongMultiMap;
};

#endif // _PLUGIN_SORT_H_
