/***************************************************************************
                          katefll_initplugin.cpp  -  description
                             -------------------
    begin                : FRE July 12th 2002
    copyright            : (C) 2002 by Joseph Wenninger
    email                : jowenn@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "katefll_initplugin.h"
#include "katefll_initplugin.moc"

#include <kate/pluginmanager.h>

#include <tqfileinfo.h>
#include <kgenericfactory.h>
#include <tdeaction.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <kurl.h>
#include <tdeio/netaccess.h>
                                     
K_EXPORT_COMPONENT_FACTORY( katefll_initplugin, KGenericFactory<InitPluginKateFileListLoader>( "katefll_loader" ) )

InitPluginKateFileListLoader::InitPluginKateFileListLoader (TQObject * parent, const char *name, const TQStringList datalist)
	:InitPlugin((Kate::Application*)parent,name)
{
}


InitPluginKateFileListLoader:: ~InitPluginKateFileListLoader()
{
}


int InitPluginKateFileListLoader::actionsKateShouldNotPerformOnRealStartup()
{
	return 0x1;
}

int InitPluginKateFileListLoader::initKate()
{
	TQString tmpFile;
	KURL tmpURL;
	if( TDEIO::NetAccess::download( configScript(), tmpFile ) )
	{
		TQFile file(tmpFile);
		file.open(IO_ReadOnly);
		
		TQTextStream t(&file);

		bool somethingOpened=false;
	
		application()->documentManager()->closeAllDocuments();
		while (!t.eof())
		{
			somethingOpened=true;
//			application()->activeMainWindow()->viewManager()->openURL(KURL(t.readLine()));
			application()->documentManager()->openURL(tmpURL=KURL(t.readLine()));
		}
		if (!somethingOpened) application()->documentManager()->openURL(KURL());
		else if (application()->activeMainWindow())
		application()->activeMainWindow()->viewManager()->openURL(tmpURL);

		file.close();

		TDEIO::NetAccess::removeTempFile( tmpFile );

	} else application()->documentManager()->openURL(KURL());

	Kate::Plugin *pl=application()->pluginManager()->plugin("katefll_plugin");
	if (pl) 
	{
			connect(this,TQT_SIGNAL(updateInit()),pl,TQT_SLOT(updateInit()));
			updateInit();
			disconnect(this,TQT_SIGNAL(updateInit()),pl,TQT_SLOT(updateInit()));
			
/*      		int id = pl->metaObject()->findSlot( TQT_SLOT(updateInit()) );
	        if ( id != -1 )
		{
        		kdDebug()<<"Action slot was found, it will be called now"<<endl;
        		TQUObject o[ 1 ];
        		mod->module->tqt_invoke( id, o );
		} */
	}
	return 0;
}

