/*
  Copyright (c) 1997 Christian Czezatke (e9025461@student.tuwien.ac.at)
                1998 Bernd Wuebben <wuebben@kde.org>
                2000 Matthias Elter <elter@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef __bell_h__
#define __bell_h__

#include "tdecmodule.h"

class TQCheckBox;
class KIntNumInput;
class TQPushButton;

class KBellConfig : public TDECModule
{
  Q_OBJECT

 public:
  KBellConfig(TQWidget *parent, const char *name);

  void load();
  void load( bool useDefaults );
  void save();
  void defaults();

 protected slots:
  void ringBell();
  void useBell( bool );

 private:
  TQPushButton  *m_testButton;
  KIntNumInput *m_volume;
  KIntNumInput *m_pitch;
  KIntNumInput *m_duration;
  TQCheckBox    *m_useBell;
};

#endif
