#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <kcombobox.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <klineedit.h>
#include "NewWindowDialog.h"

NewWindowDialog::NewWindowDialog(const KSircChannel &channelInfo, TQWidget * parent, const char * name)
    : KDialogBase(parent, name, true, i18n("New Window For"), Ok|Cancel, Ok, true),
      m_channelInfo(channelInfo)
{
  TQHBox * w = makeHBoxMainWidget();

  TQLabel * l = new TQLabel(i18n("C&hannel/Nick:"), w);

  m_combo = new KHistoryCombo(w);
  m_combo->setFocus();

  // we don't need duplicated channel into the list
  m_combo->setDuplicatesEnabled( false );

  l->setBuddy(m_combo);

  TQLabel * l2 = new TQLabel(i18n("&Key:"), w);
  m_le = new KLineEdit(w);
  m_le->setEnabled(false);
  l2->setBuddy(m_le);

  connect(
      m_combo, TQT_SIGNAL(activated(const TQString &)),
      m_combo, TQT_SLOT(addToHistory(const TQString &)));
  connect( m_combo->lineEdit(), TQT_SIGNAL(textChanged ( const TQString & )),
	   this, TQT_SLOT( slotTextChanged( const TQString &)));

  TDEConfig *kConfig = kapp->config();
  TDEConfigGroupSaver saver(kConfig, "Recent");
  m_combo->setHistoryItems(kConfig->readListEntry("Channels"));
  slotTextChanged( m_combo->lineEdit()->text());
}

NewWindowDialog::~NewWindowDialog()
{
  TDEConfig *kConfig = kapp->config();
  TDEConfigGroupSaver saver(kConfig, "Recent");
  kConfig->writeEntry("Channels", m_combo->historyItems());
}

void NewWindowDialog::slotTextChanged( const TQString &text)
{
  enableButtonOK( !text.isEmpty() );

  if(text[0] == "#" || text[0] == "&")
    m_le->setEnabled(true);
  else
    m_le->setEnabled(false);
}


  void
NewWindowDialog::slotOk()
{
  m_channelInfo.setChannel(m_combo->lineEdit()->text().lower());
  if(m_le->isEnabled())
    m_channelInfo.setKey(m_le->text());
  emit(openTopLevel(m_channelInfo));
  KDialogBase::slotOk();
}

#include "NewWindowDialog.moc"

