/***************************************************************************
                                   main.cpp
                             -------------------
    begin                : Sat Dec  8 03:23:02 CET 2001
    copyright            : (C) 2001-2003 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "trayicon.h"
#include "configuration.h"
#include "krfbifaceimpl.h"
#include "rfbcontroller.h"

#include <kpixmap.h>
#include <tdeaction.h>
#include <kdebug.h>
#include <tdeapplication.h>
#include <knotifyclient.h>
#include <ksystemtray.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdeaboutapplication.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tqobject.h>
#include <tqwindowdefs.h>
#include <tqcstring.h>
#include <tqdatastream.h>
#include <dcopref.h>

#include <signal.h>

#undef VERSION
#define VERSION "1.0"

static const char description[] = I18N_NOOP("VNC-compatible server to share "
					   "TDE desktops");
#define ARG_KINETD "kinetd"


static TDECmdLineOptions options[] =
{
	{ ARG_KINETD " ", I18N_NOOP("Used for calling from kinetd"), 0},
	TDECmdLineLastOption
};

void checkKInetd(bool &kinetdAvailable, bool &krfbAvailable) {
	DCOPRef ref("kded", "kinetd");
	ref.setDCOPClient(TDEApplication::dcopClient());

	DCOPReply r = ref.call("isInstalled", TQString("krfb"));
	if (!r.isValid()) {
		kinetdAvailable = false;
		krfbAvailable = false;
		return;
	}

	r.get(krfbAvailable);
	kinetdAvailable = true;
}

int main(int argc, char *argv[])
{
	TDEAboutData aboutData( "krfb", I18N_NOOP("Desktop Sharing"),
		VERSION, description, TDEAboutData::License_GPL,
		"(c) 2001-2003, Tim Jansen\n"
		"(c) 2001, Johannes E. Schindelin\n"
		"(c) 2000, heXoNet Support GmbH, D-66424 Homburg\n"
		"(c) 2000-2001, Const Kaplinsky\n"
		"(c) 2000, Tridia Corporation\n"
		"(c) 1999, AT&T Laboratories Cambridge\n",
                0, "", "tim@tjansen.de");
	aboutData.addAuthor("Tim Jansen", "", "tim@tjansen.de");
        aboutData.addAuthor("Ian Reinhart Geiser", "DCOP interface", "geiseri@kde.org");
	aboutData.addCredit("Johannes E. Schindelin",
			    I18N_NOOP("libvncserver"));
	aboutData.addCredit("Const Kaplinsky",
			    I18N_NOOP("TightVNC encoder"));
	aboutData.addCredit("Tridia Corporation",
			    I18N_NOOP("ZLib encoder"));
	aboutData.addCredit("AT&T Laboratories Cambridge",
			    I18N_NOOP("original VNC encoders and "
				      "protocol design"));
	aboutData.addCredit("Jens Wagner (heXoNet Support GmbH)",
			    I18N_NOOP("X11 update scanner, "
				      "original code base"));
	aboutData.addCredit("Jason Spisak",
			    I18N_NOOP("Connection side image"),
			    "kovalid@yahoo.com");
	aboutData.addCredit("Karl Vogel",
			    I18N_NOOP("KDesktop background deactivation"));
	TDECmdLineArgs::init(argc, argv, &aboutData);
	TDECmdLineArgs::addCmdLineOptions(options);

	TDEApplication app;

	Configuration *config;
	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
	TQString fdString;
	if (!args->isSet(ARG_KINETD)) {
		bool kinetdA, krfbA;
		checkKInetd(kinetdA, krfbA);
		if (!kinetdA) {
		        KMessageBox::error(0,
					   i18n("Cannot find KInetD. "
						"The TDE daemon (kded) may have crashed or has not been started at all, or the installation failed."),
					   i18n("Desktop Sharing Error"));
			return 1;
		}
		if (!krfbA) {
		        KMessageBox::error(0,
					   i18n("Cannot find KInetD service for Desktop Sharing (krfb). "
						"The installation is incomplete or failed."),
					   i18n("Desktop Sharing Error"));
			return 1;
		}

		config = new Configuration(KRFB_INVITATION_MODE);
		config->showInvitationDialog();
		return 0;
	}
	fdString = args->getOption(ARG_KINETD);
	config = new Configuration(KRFB_KINETD_MODE);
	args->clear();

	if ((!config->allowUninvitedConnections()) && (config->invitations().size() == 0)) {
		KNotifyClient::event("UnexpectedConnection");
		return 1;
        }

	if (!RFBController::checkX11Capabilities())
		return 1;

	TrayIcon trayicon(new TDEAboutApplication(&aboutData),
			  config);
	RFBController controller(config);
	KRfbIfaceImpl dcopiface(&controller);

	TQObject::connect(&app, TQT_SIGNAL(lastWindowClosed()), // dont show passivepopup
			 &trayicon, TQT_SLOT(prepareQuit()));
	TQObject::connect(&app, TQT_SIGNAL(lastWindowClosed()),
			 &controller, TQT_SLOT(closeConnection()));

	TQObject::connect(&trayicon, TQT_SIGNAL(showManageInvitations()),
			 config, TQT_SLOT(showManageInvitationsDialog()));
	TQObject::connect(&trayicon, TQT_SIGNAL(enableDesktopControl(bool)),
			 &controller, TQT_SLOT(enableDesktopControl(bool)));
	TQObject::connect(&trayicon, TQT_SIGNAL(diconnectedMessageDisplayed()),
			 &app, TQT_SLOT(quit()));

	TQObject::connect(&dcopiface, TQT_SIGNAL(exitApp()),
			 &controller, TQT_SLOT(closeConnection()));
	TQObject::connect(&dcopiface, TQT_SIGNAL(exitApp()),
			 &app, TQT_SLOT(quit()));

	TQObject::connect(&controller, TQT_SIGNAL(sessionRefused()),
			 &app, TQT_SLOT(quit()));
	TQObject::connect(&controller, TQT_SIGNAL(sessionEstablished(TQString)),
			 &trayicon, TQT_SLOT(showConnectedMessage(TQString)));
	TQObject::connect(&controller, TQT_SIGNAL(sessionFinished()),
			 &trayicon, TQT_SLOT(showDisconnectedMessage()));
	TQObject::connect(&controller, TQT_SIGNAL(desktopControlSettingChanged(bool)),
			 &trayicon, TQT_SLOT(setDesktopControlSetting(bool)));
	TQObject::connect(&controller, TQT_SIGNAL(quitApp()),
			 &app, TQT_SLOT(quit()));

	sigset_t sigs;
	sigemptyset(&sigs);
	sigaddset(&sigs, SIGPIPE);
	sigprocmask(SIG_BLOCK, &sigs, 0);

	bool ok;
	int fdNum = fdString.toInt(&ok);
	if (!ok) {
	  kdError() << "kinetd fd was not numeric." << endl;
	  return 2;
	}
	controller.startServer(fdNum);

	return app.exec();
}

