
/***************************************************************************
                          dlgjabberservices.h  -  description
                             -------------------
    begin                : Mon Dec 9 2002
    copyright            : (C) 2002-2003 by Till Gerken <till@tantalo.net>
    email                : kopete-devel@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGJABBERSERVICES_H
#define DLGJABBERSERVICES_H

#include <tqwidget.h>

#include "jabberaccount.h"
#include "xmpp_tasks.h"

#include "dlgservices.h"
#include <tqlistview.h>

/**
  *@author Till Gerken <till@tantalo.net>
  */

class dlgJabberServices:public dlgServices
{
	Q_OBJECT
  

public:
	  dlgJabberServices (JabberAccount *account, TQWidget *parent = 0, const char *name = 0);
	 ~dlgJabberServices ();

private slots:
	void slotSetSelection (TQListViewItem *);
	void slotService ();
	void slotServiceFinished ();
	void slotRegister ();
	void slotBrowse ();
	
	void slotDisco();
	void slotDiscoFinished();

private:
	JabberAccount *m_account;
	XMPP::Jid current_jid;

};


class dlgJabberServies_item : protected TQObject, public TQListViewItem  
{
	Q_OBJECT
  
	public:
		dlgJabberServies_item( TQListView *parent , const TQString &s1 , const TQString &s2 ) 
			: TQListViewItem(parent,s1,s2), can_browse(false) , can_register(false) {}
		bool can_browse, can_register;
		XMPP::Jid jid;
		
		void updateInfo(const XMPP::Jid& jid, const TQString &node , JabberAccount *account);
	private slots:
		void slotDiscoFinished();
};

#endif
