/*
    ircaddcontactpage.cpp - IRC Add Contact Widget

    Copyright (c) 2002      by Nick Betcher <nbetcher@kde.org>

    Kopete    (c) 2002      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "ircadd.h"
#include "ircaddcontactpage.h"
#include "channellist.h"

#include "kircengine.h"

#include "ircaccount.h"

#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqframe.h>
#include <tqtabwidget.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

IRCAddContactPage::IRCAddContactPage( TQWidget *parent, IRCAccount *a ) : AddContactPage(parent, 0)
{
	(new TQVBoxLayout(this))->setAutoAdd(true);
	ircdata = new ircAddUI(this);
	mSearch = new ChannelList( (TQWidget*)ircdata->hbox, a->engine() );
	mAccount = a;

	connect( mSearch, TQT_SIGNAL( channelSelected( const TQString & ) ),
		this, TQT_SLOT( slotChannelSelected( const TQString & ) ) );

	connect( mSearch, TQT_SIGNAL( channelDoubleClicked( const TQString & ) ),
		this, TQT_SLOT( slotChannelDoubleClicked( const TQString & ) ) );
}

IRCAddContactPage::~IRCAddContactPage()
{
}

void IRCAddContactPage::slotChannelSelected( const TQString &channel )
{
	ircdata->addID->setText( channel );
}

void IRCAddContactPage::slotChannelDoubleClicked( const TQString &channel )
{
	ircdata->addID->setText( channel );
	ircdata->tabWidget3->setCurrentPage(0);
}

bool IRCAddContactPage::apply(Kopete::Account *account , Kopete::MetaContact *m)
{
	TQString name = ircdata->addID->text();
	return account->addContact(name, m, Kopete::Account::ChangeKABC );
}

bool IRCAddContactPage::validateData()
{
	TQString name = ircdata->addID->text();
	if (name.isEmpty() == true)
	{
		KMessageBox::sorry(this, i18n("<qt>You need to specify a channel to join, or query to open.</qt>"), i18n("You Must Specify a Channel"));
		return false;
	}
	return true;
}

#include "ircaddcontactpage.moc"
