/*
    Kopete Groupwise Protocol
    gwcontactproperties.cpp - dialog showing a contact's server side properties

    Copyright (c) 2004      SUSE Linux AG	 	 http://www.suse.com
    
    Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>
 
    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include <tqclipboard.h>
#include <tqheader.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tdelistview.h>
#include <tqmap.h>
#include <tqpopupmenu.h>

#include <tdeapplication.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include <tdelocale.h>
#include <kopeteglobal.h>
#include <kopeteonlinestatus.h>
#include <kopetemetacontact.h>
#include <kopeteuiglobal.h>
#include <tdeaction.h>
#include <kstdaction.h>

#include "gwcontact.h"
#include "gwcontactpropswidget.h"
#include "gwprotocol.h"

#include "gwcontactproperties.h"

GroupWiseContactProperties::GroupWiseContactProperties( GroupWiseContact * contact, TQWidget *parent, const char *name)
 : TQObject(parent, name)
{
	init();
	// set up the contents of the props widget
	m_propsWidget->m_userId->setText( contact->contactId() );
	m_propsWidget->m_status->setText( contact->onlineStatus().description() );
	m_propsWidget->m_displayName->setText( contact->metaContact()->displayName() );
	m_propsWidget->m_firstName->setText( contact->property( Kopete::Global::Properties::self()->firstName() ).value().toString() );
	m_propsWidget->m_lastName->setText( contact->property( Kopete::Global::Properties::self()->lastName() ).value().toString() );
	
	setupProperties( contact->serverProperties() );
	m_dialog->show();
}

GroupWiseContactProperties::GroupWiseContactProperties( GroupWise::ContactDetails cd, TQWidget *parent, const char *name )
 : TQObject(parent, name)
{
	init();
	// set up the contents of the props widget
	m_propsWidget->m_userId->setText( GroupWiseProtocol::protocol()->dnToDotted( cd.dn ) );
	m_propsWidget->m_status->setText( GroupWiseProtocol::protocol()->gwStatusToKOS( cd.status ).description() );
	m_propsWidget->m_displayName->setText( cd.fullName.isEmpty() ? ( cd.givenName + " " + cd.surname ) : cd.fullName );
	m_propsWidget->m_firstName->setText( cd.givenName );
	m_propsWidget->m_lastName->setText( cd.surname );

	setupProperties( cd.properties );

	m_dialog->show();
}

GroupWiseContactProperties::~GroupWiseContactProperties()
{
}

void GroupWiseContactProperties::init()
{
	m_dialog = new KDialogBase( ::tqqt_cast<TQWidget*>( parent() ), "gwcontactpropsdialog", false, i18n( "Contact Properties" ), KDialogBase::Ok );
	m_propsWidget = new GroupWiseContactPropsWidget( m_dialog );
	// set up the context menu and copy action
	m_copyAction = KStdAction::copy( this, TQT_SLOT( slotCopy() ), 0 );
	connect( m_propsWidget->m_propsView, 
			 TQT_SIGNAL( contextMenuRequested( TQListViewItem *, const TQPoint & , int) ),
			 TQT_SLOT( slotShowContextMenu( TQListViewItem *, const TQPoint & ) ) );

	// insert the props widget into the dialog
	m_dialog->setMainWidget( m_propsWidget );
}

void GroupWiseContactProperties::setupProperties( TQMap< TQString, TQString > serverProps )
{
	m_propsWidget->m_propsView->header()->hide();
	TQMap< TQString, TQString >::Iterator it;
	TQMap< TQString, TQString >::Iterator end = serverProps.end();
	for ( it = serverProps.begin(); it != end; ++it )
	{
		kdDebug( GROUPWISE_DEBUG_GLOBAL ) << " adding property: " << it.key() << ", " << it.data() << endl;
		TQString key = it.key();
		TQString localised;
		if ( key == "telephoneNumber" )
			localised = i18n( "Telephone Number" );
		else if ( key == "OU" )
			localised = i18n( "Department" );
		else if ( key == "L" )
			localised = i18n( "Location" );
		else if ( key == "mailstop" )
			localised = i18n( "Mailstop" );
		else if ( key == "personalTitle" )
			localised = i18n( "Personal Title" );
		else if ( key == "title" )
			localised = i18n( "Title" );
		else if ( key == "Internet EMail Address" )
			localised = i18n( "Email Address" );
		else
			localised = key;

		new TDEListViewItem( m_propsWidget->m_propsView, localised, it.data() );
	}
}

void GroupWiseContactProperties::slotShowContextMenu( TQListViewItem * item, const TQPoint & pos )
{
	if ( item )
		kdDebug( GROUPWISE_DEBUG_GLOBAL ) << "for item " << item->text(0) << ", " << item->text(1) << endl;
	else
		kdDebug( GROUPWISE_DEBUG_GLOBAL ) << "no selected item" << endl;
	TQPopupMenu * popupMenu = new TQPopupMenu( m_propsWidget->m_propsView );
	m_copyAction->plug( popupMenu );
	popupMenu->exec( pos );
}

void GroupWiseContactProperties::slotCopy()
{
	kdDebug( GROUPWISE_DEBUG_GLOBAL ) << k_funcinfo << endl;
	if ( m_propsWidget->m_propsView->currentItem() )
	{
		TQClipboard *cb = kapp->clipboard();
		cb->setText( m_propsWidget->m_propsView->currentItem()->text( 1 ) );
	}
}
#include "gwcontactproperties.moc"
