/***************************************************************************
                          contactnotes.cpp  -  description
                             -------------------
    begin                : lun sep 16 2002
    copyright            : (C) 2002 by Olivier Goffart
    email                : ogoffart @ kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeaction.h>
#include <kdebug.h>
#include <kgenericfactory.h>

#include "kopetemetacontact.h"
#include "kopetecontactlist.h"

#include "contactnotesedit.h"

#include "contactnotesplugin.h"

typedef KGenericFactory<ContactNotesPlugin> ContactNotesPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kopete_contactnotes, ContactNotesPluginFactory( "kopete_contactnotes" )  )

ContactNotesPlugin::ContactNotesPlugin( TQObject *parent, const char *name, const TQStringList & /* args */ )
: Kopete::Plugin( ContactNotesPluginFactory::instance(), parent, name )
{
	if ( pluginStatic_ )
		kdDebug(14302)<<"ContactNotesPlugin::ContactNotesPlugin : plugin already initialized"<<endl;
	else
		pluginStatic_ = this;

	TDEAction *m_actionEdit=new TDEAction( i18n("&Notes"), "identity", 0, this, TQT_SLOT (slotEditInfo()), actionCollection() , "editContactNotes");
	connect ( Kopete::ContactList::self() , TQT_SIGNAL( metaContactSelected(bool)) , m_actionEdit , TQT_SLOT(setEnabled(bool)));
	m_actionEdit->setEnabled(Kopete::ContactList::self()->selectedMetaContacts().count()==1 );

	setXMLFile("contactnotesui.rc");
}

ContactNotesPlugin::~ContactNotesPlugin()
{
	pluginStatic_ = 0L;
}

ContactNotesPlugin* ContactNotesPlugin::plugin()
{
	return pluginStatic_ ;
}

ContactNotesPlugin* ContactNotesPlugin::pluginStatic_ = 0L;


void ContactNotesPlugin::slotEditInfo()
{
	Kopete::MetaContact *m=Kopete::ContactList::self()->selectedMetaContacts().first();
	if(!m)
		return;
	ContactNotesEdit *e=new ContactNotesEdit(m,this);
	connect( e, TQT_SIGNAL( notesChanged( const TQString, Kopete::MetaContact*) ),this,
			TQT_SLOT( setNotes( const TQString, Kopete::MetaContact * ) ) );
	e->show();
}


TQString ContactNotesPlugin::notes(Kopete::MetaContact *m)
{
	return m->pluginData( this, "notes" );
}

void ContactNotesPlugin::setNotes( const TQString n, Kopete::MetaContact *m )
{
	m->setPluginData( this, "notes", n );
}

#include "contactnotesplugin.moc"

