/*
    kopetehistorydialog.h - Kopete Away Action

    Copyright (c) 2003     Jason Keirstead   <jason@keirstead.org>

    Kopete    (c) 2002 by the Kopete developers  <kopete-devel@kde.org>

   *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETEAWAYACTION_H
#define KOPETEAWAYACTION_H

#include <tdeversion.h>
#include <tdeactionclasses.h>
#include <tdeaction.h>

#include "kopete_export.h"

namespace Kopete
{

class OnlineStatus;

/**
 * @class Kopete::AwayAction
 *
 * Kopete::AwayAction is a TDEAction that lets you select an away message
 * from the list of predefined away messages, or enter a custom one.
 *
 * @author Jason Keirstead   <jason@keirstead.org>
 */
class KOPETE_EXPORT AwayAction : public TDESelectAction
{
	Q_OBJECT
  
	public:
		/**
		 * Constructor
		 * @p text, @p pix, @p cut, @p receiver, @p slot, @p parent and
		 * @p name are all handled by TDESelectAction.
		 **/
		AwayAction(const TQString &text, const TQIconSet &pix,
				   const TDEShortcut &cut, const TQObject *receiver, const char *slot,
				   TQObject *parent, const char *name = 0);

		/**
		 * Constructor
		 * @param status the OnlineStatus that appears in the signal
		 * @param slot must have the following signature:  ( const OnlineStatus &, const TQString & )
		 * @p text, @p pix, @p cut, @p receiver, @p slot, @p parent and
		 * @p name are all handled by TDESelectAction.
		 **/
		AwayAction(const OnlineStatus &status, const TQString &text, const TQIconSet &pix,
				   const TDEShortcut &cut, const TQObject *receiver, const char *slot,
				   TQObject *parent, const char *name = 0);

		/**
	 	 * Destructor.
	 	 */
		~AwayAction();

	signals:
		/**
		* @brief Emits when the user selects an away message
		*/
		void awayMessageSelected( const TQString & );

		 /**
		  * same as above, but with the saved status
		  */
		void awayMessageSelected( const Kopete::OnlineStatus& , const TQString & );

	private slots:
		void slotAwayChanged();
		void slotSelectAway( int index );

	private:
		class Private;
		Private *d;
};

}

#endif
